/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmdataexports.model.TablePropertyDescription;
import software.amazon.awssdk.services.bcmdataexports.model.TablePropertyDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Table
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Table> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Table.getter(Table::description)).setter(Table.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(Table.getter(Table::tableName)).setter(Table.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<TablePropertyDescription>> TABLE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableProperties").getter(Table.getter(Table::tableProperties)).setter(Table.setter(Builder::tableProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TablePropertyDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, TABLE_NAME_FIELD, TABLE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Table.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String tableName;
    private final List<TablePropertyDescription> tableProperties;

    private Table(BuilderImpl builder) {
        this.description = builder.description;
        this.tableName = builder.tableName;
        this.tableProperties = builder.tableProperties;
    }

    public final String description() {
        return this.description;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasTableProperties() {
        return this.tableProperties != null && !(this.tableProperties instanceof SdkAutoConstructList);
    }

    public final List<TablePropertyDescription> tableProperties() {
        return this.tableProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableProperties() ? this.tableProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.tableName(), other.tableName()) && this.hasTableProperties() == other.hasTableProperties() && Objects.equals(this.tableProperties(), other.tableProperties());
    }

    public final String toString() {
        return ToString.builder((String)"Table").add("Description", (Object)this.description()).add("TableName", (Object)this.tableName()).add("TableProperties", this.hasTableProperties() ? this.tableProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableProperties": {
                return Optional.ofNullable(clazz.cast(this.tableProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TableProperties", TABLE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Table, T> g) {
        return obj -> g.apply((Table)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String tableName;
        private List<TablePropertyDescription> tableProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Table model) {
            this.description(model.description);
            this.tableName(model.tableName);
            this.tableProperties(model.tableProperties);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<TablePropertyDescription.Builder> getTableProperties() {
            List<TablePropertyDescription.Builder> result = TablePropertyDescriptionListCopier.copyToBuilder(this.tableProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableProperties(Collection<TablePropertyDescription.BuilderImpl> tableProperties) {
            this.tableProperties = TablePropertyDescriptionListCopier.copyFromBuilder(tableProperties);
        }

        @Override
        public final Builder tableProperties(Collection<TablePropertyDescription> tableProperties) {
            this.tableProperties = TablePropertyDescriptionListCopier.copy(tableProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableProperties(TablePropertyDescription ... tableProperties) {
            this.tableProperties(Arrays.asList(tableProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableProperties(Consumer<TablePropertyDescription.Builder> ... tableProperties) {
            this.tableProperties(Stream.of(tableProperties).map(c -> (TablePropertyDescription)((TablePropertyDescription.Builder)TablePropertyDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Table build() {
            return new Table(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Table> {
        public Builder description(String var1);

        public Builder tableName(String var1);

        public Builder tableProperties(Collection<TablePropertyDescription> var1);

        public Builder tableProperties(TablePropertyDescription ... var1);

        public Builder tableProperties(Consumer<TablePropertyDescription.Builder> ... var1);
    }
}

