/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bcmdataexports.BcmDataExportsClientBuilder;
import software.amazon.awssdk.services.bcmdataexports.BcmDataExportsServiceClientConfiguration;
import software.amazon.awssdk.services.bcmdataexports.DefaultBcmDataExportsClientBuilder;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsException;
import software.amazon.awssdk.services.bcmdataexports.model.CreateExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.CreateExportResponse;
import software.amazon.awssdk.services.bcmdataexports.model.DeleteExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.DeleteExportResponse;
import software.amazon.awssdk.services.bcmdataexports.model.GetExecutionRequest;
import software.amazon.awssdk.services.bcmdataexports.model.GetExecutionResponse;
import software.amazon.awssdk.services.bcmdataexports.model.GetExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.GetExportResponse;
import software.amazon.awssdk.services.bcmdataexports.model.GetTableRequest;
import software.amazon.awssdk.services.bcmdataexports.model.GetTableResponse;
import software.amazon.awssdk.services.bcmdataexports.model.InternalServerException;
import software.amazon.awssdk.services.bcmdataexports.model.ListExecutionsRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListExecutionsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ListExportsRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListExportsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ListTablesRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListTablesResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmdataexports.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bcmdataexports.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bcmdataexports.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmdataexports.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ThrottlingException;
import software.amazon.awssdk.services.bcmdataexports.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmdataexports.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmdataexports.model.UpdateExportRequest;
import software.amazon.awssdk.services.bcmdataexports.model.UpdateExportResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ValidationException;
import software.amazon.awssdk.services.bcmdataexports.paginators.ListExecutionsIterable;
import software.amazon.awssdk.services.bcmdataexports.paginators.ListExportsIterable;
import software.amazon.awssdk.services.bcmdataexports.paginators.ListTablesIterable;

@SdkPublicApi
@ThreadSafe
public interface BcmDataExportsClient
extends AwsClient {
    public static final String SERVICE_NAME = "bcm-data-exports";
    public static final String SERVICE_METADATA_ID = "bcm-data-exports";

    default public CreateExportResponse createExport(CreateExportRequest createExportRequest) throws ServiceQuotaExceededException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public CreateExportResponse createExport(Consumer<CreateExportRequest.Builder> createExportRequest) throws ServiceQuotaExceededException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.createExport((CreateExportRequest)((Object)((CreateExportRequest.Builder)CreateExportRequest.builder().applyMutation(createExportRequest)).build()));
    }

    default public DeleteExportResponse deleteExport(DeleteExportRequest deleteExportRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteExportResponse deleteExport(Consumer<DeleteExportRequest.Builder> deleteExportRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.deleteExport((DeleteExportRequest)((Object)((DeleteExportRequest.Builder)DeleteExportRequest.builder().applyMutation(deleteExportRequest)).build()));
    }

    default public GetExecutionResponse getExecution(GetExecutionRequest getExecutionRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public GetExecutionResponse getExecution(Consumer<GetExecutionRequest.Builder> getExecutionRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.getExecution((GetExecutionRequest)((Object)((GetExecutionRequest.Builder)GetExecutionRequest.builder().applyMutation(getExecutionRequest)).build()));
    }

    default public GetExportResponse getExport(GetExportRequest getExportRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public GetExportResponse getExport(Consumer<GetExportRequest.Builder> getExportRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.getExport((GetExportRequest)((Object)((GetExportRequest.Builder)GetExportRequest.builder().applyMutation(getExportRequest)).build()));
    }

    default public GetTableResponse getTable(GetTableRequest getTableRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public GetTableResponse getTable(Consumer<GetTableRequest.Builder> getTableRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.getTable((GetTableRequest)((Object)((GetTableRequest.Builder)GetTableRequest.builder().applyMutation(getTableRequest)).build()));
    }

    default public ListExecutionsResponse listExecutions(ListExecutionsRequest listExecutionsRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public ListExecutionsResponse listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.listExecutions((ListExecutionsRequest)((Object)((ListExecutionsRequest.Builder)ListExecutionsRequest.builder().applyMutation(listExecutionsRequest)).build()));
    }

    default public ListExecutionsIterable listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return new ListExecutionsIterable(this, listExecutionsRequest);
    }

    default public ListExecutionsIterable listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.listExecutionsPaginator((ListExecutionsRequest)((Object)((ListExecutionsRequest.Builder)ListExecutionsRequest.builder().applyMutation(listExecutionsRequest)).build()));
    }

    default public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public ListExportsResponse listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.listExports((ListExportsRequest)((Object)((ListExportsRequest.Builder)ListExportsRequest.builder().applyMutation(listExportsRequest)).build()));
    }

    default public ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return new ListExportsIterable(this, listExportsRequest);
    }

    default public ListExportsIterable listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.listExportsPaginator((ListExportsRequest)((Object)((ListExportsRequest.Builder)ListExportsRequest.builder().applyMutation(listExportsRequest)).build()));
    }

    default public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public ListTablesResponse listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.listTables((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return new ListTablesIterable(this, listTablesRequest);
    }

    default public ListTablesIterable listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) throws InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.listTablesPaginator((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateExportResponse updateExport(UpdateExportRequest updateExportRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        throw new UnsupportedOperationException();
    }

    default public UpdateExportResponse updateExport(Consumer<UpdateExportRequest.Builder> updateExportRequest) throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, BcmDataExportsException {
        return this.updateExport((UpdateExportRequest)((Object)((UpdateExportRequest.Builder)UpdateExportRequest.builder().applyMutation(updateExportRequest)).build()));
    }

    public static BcmDataExportsClient create() {
        return (BcmDataExportsClient)BcmDataExportsClient.builder().build();
    }

    public static BcmDataExportsClientBuilder builder() {
        return new DefaultBcmDataExportsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"bcm-data-exports");
    }

    default public BcmDataExportsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

