/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.CompressionOption;
import software.amazon.awssdk.services.bcmdataexports.model.FormatOption;
import software.amazon.awssdk.services.bcmdataexports.model.OverwriteOption;
import software.amazon.awssdk.services.bcmdataexports.model.S3OutputType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3OutputConfigurations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3OutputConfigurations> {
    private static final SdkField<String> COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compression").getter(S3OutputConfigurations.getter(S3OutputConfigurations::compressionAsString)).setter(S3OutputConfigurations.setter(Builder::compression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compression").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(S3OutputConfigurations.getter(S3OutputConfigurations::formatAsString)).setter(S3OutputConfigurations.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(S3OutputConfigurations.getter(S3OutputConfigurations::outputTypeAsString)).setter(S3OutputConfigurations.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()}).build();
    private static final SdkField<String> OVERWRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Overwrite").getter(S3OutputConfigurations.getter(S3OutputConfigurations::overwriteAsString)).setter(S3OutputConfigurations.setter(Builder::overwrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overwrite").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPRESSION_FIELD, FORMAT_FIELD, OUTPUT_TYPE_FIELD, OVERWRITE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String compression;
    private final String format;
    private final String outputType;
    private final String overwrite;

    private S3OutputConfigurations(BuilderImpl builder) {
        this.compression = builder.compression;
        this.format = builder.format;
        this.outputType = builder.outputType;
        this.overwrite = builder.overwrite;
    }

    public final CompressionOption compression() {
        return CompressionOption.fromValue(this.compression);
    }

    public final String compressionAsString() {
        return this.compression;
    }

    public final FormatOption format() {
        return FormatOption.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final S3OutputType outputType() {
        return S3OutputType.fromValue(this.outputType);
    }

    public final String outputTypeAsString() {
        return this.outputType;
    }

    public final OverwriteOption overwrite() {
        return OverwriteOption.fromValue(this.overwrite);
    }

    public final String overwriteAsString() {
        return this.overwrite;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OutputConfigurations)) {
            return false;
        }
        S3OutputConfigurations other = (S3OutputConfigurations)obj;
        return Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.outputTypeAsString(), other.outputTypeAsString()) && Objects.equals(this.overwriteAsString(), other.overwriteAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3OutputConfigurations").add("Compression", (Object)this.compressionAsString()).add("Format", (Object)this.formatAsString()).add("OutputType", (Object)this.outputTypeAsString()).add("Overwrite", (Object)this.overwriteAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputTypeAsString()));
            }
            case "Overwrite": {
                return Optional.ofNullable(clazz.cast(this.overwriteAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3OutputConfigurations, T> g) {
        return obj -> g.apply((S3OutputConfigurations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String compression;
        private String format;
        private String outputType;
        private String overwrite;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OutputConfigurations model) {
            this.compression(model.compression);
            this.format(model.format);
            this.outputType(model.outputType);
            this.overwrite(model.overwrite);
        }

        public final String getCompression() {
            return this.compression;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(CompressionOption compression) {
            this.compression(compression == null ? null : compression.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(FormatOption format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(S3OutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final String getOverwrite() {
            return this.overwrite;
        }

        public final void setOverwrite(String overwrite) {
            this.overwrite = overwrite;
        }

        @Override
        public final Builder overwrite(String overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        @Override
        public final Builder overwrite(OverwriteOption overwrite) {
            this.overwrite(overwrite == null ? null : overwrite.toString());
            return this;
        }

        public S3OutputConfigurations build() {
            return new S3OutputConfigurations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3OutputConfigurations> {
        public Builder compression(String var1);

        public Builder compression(CompressionOption var1);

        public Builder format(String var1);

        public Builder format(FormatOption var1);

        public Builder outputType(String var1);

        public Builder outputType(S3OutputType var1);

        public Builder overwrite(String var1);

        public Builder overwrite(OverwriteOption var1);
    }
}

