/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Web Services Billing and Cost Management Dashboards is a service that enables you to create, manage, and share
 * dashboards that combine multiple visualizations of your Amazon Web Services cost and usage data. You can combine
 * multiple data sources including Cost Explorer, Savings Plans, and Reserved Instance metrics into unified dashboards,
 * helping you analyze spending patterns and share cost insights across your organization.
 * </p>
 * <p>
 * You can use the Amazon Web Services Billing and Cost Management Dashboards API to programmatically create, manage,
 * and share dashboards. This includes creating custom dashboards, configuring widgets, managing dashboard permissions,
 * and sharing dashboards across accounts in your organization.
 * </p>
 */
package software.amazon.awssdk.services.bcmdashboards;