/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.ServiceJobEvaluateOnExit;
import software.amazon.awssdk.services.batch.model.ServiceJobEvaluateOnExitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceJobRetryStrategy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceJobRetryStrategy> {
    private static final SdkField<Integer> ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("attempts").getter(ServiceJobRetryStrategy.getter(ServiceJobRetryStrategy::attempts)).setter(ServiceJobRetryStrategy.setter(Builder::attempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build()}).build();
    private static final SdkField<List<ServiceJobEvaluateOnExit>> EVALUATE_ON_EXIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluateOnExit").getter(ServiceJobRetryStrategy.getter(ServiceJobRetryStrategy::evaluateOnExit)).setter(ServiceJobRetryStrategy.setter(Builder::evaluateOnExit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluateOnExit").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceJobEvaluateOnExit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD, EVALUATE_ON_EXIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceJobRetryStrategy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer attempts;
    private final List<ServiceJobEvaluateOnExit> evaluateOnExit;

    private ServiceJobRetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
        this.evaluateOnExit = builder.evaluateOnExit;
    }

    public final Integer attempts() {
        return this.attempts;
    }

    public final boolean hasEvaluateOnExit() {
        return this.evaluateOnExit != null && !(this.evaluateOnExit instanceof SdkAutoConstructList);
    }

    public final List<ServiceJobEvaluateOnExit> evaluateOnExit() {
        return this.evaluateOnExit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluateOnExit() ? this.evaluateOnExit() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceJobRetryStrategy)) {
            return false;
        }
        ServiceJobRetryStrategy other = (ServiceJobRetryStrategy)obj;
        return Objects.equals(this.attempts(), other.attempts()) && this.hasEvaluateOnExit() == other.hasEvaluateOnExit() && Objects.equals(this.evaluateOnExit(), other.evaluateOnExit());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceJobRetryStrategy").add("Attempts", (Object)this.attempts()).add("EvaluateOnExit", this.hasEvaluateOnExit() ? this.evaluateOnExit() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attempts": {
                return Optional.ofNullable(clazz.cast(this.attempts()));
            }
            case "evaluateOnExit": {
                return Optional.ofNullable(clazz.cast(this.evaluateOnExit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attempts", ATTEMPTS_FIELD);
        map.put("evaluateOnExit", EVALUATE_ON_EXIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceJobRetryStrategy, T> g) {
        return obj -> g.apply((ServiceJobRetryStrategy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer attempts;
        private List<ServiceJobEvaluateOnExit> evaluateOnExit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceJobRetryStrategy model) {
            this.attempts(model.attempts);
            this.evaluateOnExit(model.evaluateOnExit);
        }

        public final Integer getAttempts() {
            return this.attempts;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        @Override
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        public final List<ServiceJobEvaluateOnExit.Builder> getEvaluateOnExit() {
            List<ServiceJobEvaluateOnExit.Builder> result = ServiceJobEvaluateOnExitListCopier.copyToBuilder(this.evaluateOnExit);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluateOnExit(Collection<ServiceJobEvaluateOnExit.BuilderImpl> evaluateOnExit) {
            this.evaluateOnExit = ServiceJobEvaluateOnExitListCopier.copyFromBuilder(evaluateOnExit);
        }

        @Override
        public final Builder evaluateOnExit(Collection<ServiceJobEvaluateOnExit> evaluateOnExit) {
            this.evaluateOnExit = ServiceJobEvaluateOnExitListCopier.copy(evaluateOnExit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(ServiceJobEvaluateOnExit ... evaluateOnExit) {
            this.evaluateOnExit(Arrays.asList(evaluateOnExit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(Consumer<ServiceJobEvaluateOnExit.Builder> ... evaluateOnExit) {
            this.evaluateOnExit(Stream.of(evaluateOnExit).map(c -> (ServiceJobEvaluateOnExit)((ServiceJobEvaluateOnExit.Builder)ServiceJobEvaluateOnExit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceJobRetryStrategy build() {
            return new ServiceJobRetryStrategy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceJobRetryStrategy> {
        public Builder attempts(Integer var1);

        public Builder evaluateOnExit(Collection<ServiceJobEvaluateOnExit> var1);

        public Builder evaluateOnExit(ServiceJobEvaluateOnExit ... var1);

        public Builder evaluateOnExit(Consumer<ServiceJobEvaluateOnExit.Builder> ... var1);
    }
}

