/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ConsumableResourceSummary;
import software.amazon.awssdk.services.batch.model.ListConsumableResourcesRequest;
import software.amazon.awssdk.services.batch.model.ListConsumableResourcesResponse;

public class ListConsumableResourcesPublisher
implements SdkPublisher<ListConsumableResourcesResponse> {
    private final BatchAsyncClient client;
    private final ListConsumableResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConsumableResourcesPublisher(BatchAsyncClient client, ListConsumableResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConsumableResourcesPublisher(BatchAsyncClient client, ListConsumableResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConsumableResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConsumableResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConsumableResourceSummary> consumableResources() {
        return this.flatMapIterable(response -> response.consumableResources());
    }

    private class ListConsumableResourcesResponseFetcher
    implements AsyncPageFetcher<ListConsumableResourcesResponse> {
        private ListConsumableResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListConsumableResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConsumableResourcesResponse> nextPage(ListConsumableResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListConsumableResourcesPublisher.this.client.listConsumableResources(ListConsumableResourcesPublisher.this.firstRequest);
            }
            return ListConsumableResourcesPublisher.this.client.listConsumableResources((ListConsumableResourcesRequest)((Object)ListConsumableResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

