/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceEnvironmentRequest extends BatchRequest implements
        ToCopyableBuilder<UpdateServiceEnvironmentRequest.Builder, UpdateServiceEnvironmentRequest> {
    private static final SdkField<String> SERVICE_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceEnvironment").getter(getter(UpdateServiceEnvironmentRequest::serviceEnvironment))
            .setter(setter(Builder::serviceEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironment").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(UpdateServiceEnvironmentRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<List<CapacityLimit>> CAPACITY_LIMITS_FIELD = SdkField
            .<List<CapacityLimit>> builder(MarshallingType.LIST)
            .memberName("capacityLimits")
            .getter(getter(UpdateServiceEnvironmentRequest::capacityLimits))
            .setter(setter(Builder::capacityLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ENVIRONMENT_FIELD,
            STATE_FIELD, CAPACITY_LIMITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceEnvironment;

    private final String state;

    private final List<CapacityLimit> capacityLimits;

    private UpdateServiceEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.serviceEnvironment = builder.serviceEnvironment;
        this.state = builder.state;
        this.capacityLimits = builder.capacityLimits;
    }

    /**
     * <p>
     * The name or ARN of the service environment to update.
     * </p>
     * 
     * @return The name or ARN of the service environment to update.
     */
    public final String serviceEnvironment() {
        return serviceEnvironment;
    }

    /**
     * <p>
     * The state of the service environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ServiceEnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the service environment.
     * @see ServiceEnvironmentState
     */
    public final ServiceEnvironmentState state() {
        return ServiceEnvironmentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the service environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ServiceEnvironmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the service environment.
     * @see ServiceEnvironmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityLimits property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityLimits() {
        return capacityLimits != null && !(capacityLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity limits for the service environment. This defines the maximum resources that can be used by service
     * jobs in this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityLimits} method.
     * </p>
     * 
     * @return The capacity limits for the service environment. This defines the maximum resources that can be used by
     *         service jobs in this environment.
     */
    public final List<CapacityLimit> capacityLimits() {
        return capacityLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityLimits() ? capacityLimits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceEnvironmentRequest)) {
            return false;
        }
        UpdateServiceEnvironmentRequest other = (UpdateServiceEnvironmentRequest) obj;
        return Objects.equals(serviceEnvironment(), other.serviceEnvironment())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasCapacityLimits() == other.hasCapacityLimits()
                && Objects.equals(capacityLimits(), other.capacityLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceEnvironmentRequest").add("ServiceEnvironment", serviceEnvironment())
                .add("State", stateAsString()).add("CapacityLimits", hasCapacityLimits() ? capacityLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceEnvironment":
            return Optional.ofNullable(clazz.cast(serviceEnvironment()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "capacityLimits":
            return Optional.ofNullable(clazz.cast(capacityLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceEnvironment", SERVICE_ENVIRONMENT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("capacityLimits", CAPACITY_LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateServiceEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceEnvironmentRequest> {
        /**
         * <p>
         * The name or ARN of the service environment to update.
         * </p>
         * 
         * @param serviceEnvironment
         *        The name or ARN of the service environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceEnvironment(String serviceEnvironment);

        /**
         * <p>
         * The state of the service environment.
         * </p>
         * 
         * @param state
         *        The state of the service environment.
         * @see ServiceEnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEnvironmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the service environment.
         * </p>
         * 
         * @param state
         *        The state of the service environment.
         * @see ServiceEnvironmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceEnvironmentState
         */
        Builder state(ServiceEnvironmentState state);

        /**
         * <p>
         * The capacity limits for the service environment. This defines the maximum resources that can be used by
         * service jobs in this environment.
         * </p>
         * 
         * @param capacityLimits
         *        The capacity limits for the service environment. This defines the maximum resources that can be used
         *        by service jobs in this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityLimits(Collection<CapacityLimit> capacityLimits);

        /**
         * <p>
         * The capacity limits for the service environment. This defines the maximum resources that can be used by
         * service jobs in this environment.
         * </p>
         * 
         * @param capacityLimits
         *        The capacity limits for the service environment. This defines the maximum resources that can be used
         *        by service jobs in this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityLimits(CapacityLimit... capacityLimits);

        /**
         * <p>
         * The capacity limits for the service environment. This defines the maximum resources that can be used by
         * service jobs in this environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.CapacityLimit.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.CapacityLimit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.CapacityLimit.Builder#build()} is called immediately and
         * its result is passed to {@link #capacityLimits(List<CapacityLimit>)}.
         * 
         * @param capacityLimits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.CapacityLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityLimits(java.util.Collection<CapacityLimit>)
         */
        Builder capacityLimits(Consumer<CapacityLimit.Builder>... capacityLimits);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String serviceEnvironment;

        private String state;

        private List<CapacityLimit> capacityLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceEnvironmentRequest model) {
            super(model);
            serviceEnvironment(model.serviceEnvironment);
            state(model.state);
            capacityLimits(model.capacityLimits);
        }

        public final String getServiceEnvironment() {
            return serviceEnvironment;
        }

        public final void setServiceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
        }

        @Override
        public final Builder serviceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ServiceEnvironmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<CapacityLimit.Builder> getCapacityLimits() {
            List<CapacityLimit.Builder> result = CapacityLimitsCopier.copyToBuilder(this.capacityLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityLimits(Collection<CapacityLimit.BuilderImpl> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copyFromBuilder(capacityLimits);
        }

        @Override
        public final Builder capacityLimits(Collection<CapacityLimit> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copy(capacityLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(CapacityLimit... capacityLimits) {
            capacityLimits(Arrays.asList(capacityLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(Consumer<CapacityLimit.Builder>... capacityLimits) {
            capacityLimits(Stream.of(capacityLimits).map(c -> CapacityLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceEnvironmentRequest build() {
            return new UpdateServiceEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
