/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.CapacityLimit;
import software.amazon.awssdk.services.batch.model.CapacityLimitsCopier;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentState;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentStatus;
import software.amazon.awssdk.services.batch.model.ServiceEnvironmentType;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceEnvironmentDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceEnvironmentDetail> {
    private static final SdkField<String> SERVICE_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceEnvironmentName").getter(ServiceEnvironmentDetail.getter(ServiceEnvironmentDetail::serviceEnvironmentName)).setter(ServiceEnvironmentDetail.setter(Builder::serviceEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironmentName").build()}).build();
    private static final SdkField<String> SERVICE_ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceEnvironmentArn").getter(ServiceEnvironmentDetail.getter(ServiceEnvironmentDetail::serviceEnvironmentArn)).setter(ServiceEnvironmentDetail.setter(Builder::serviceEnvironmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironmentArn").build()}).build();
    private static final SdkField<String> SERVICE_ENVIRONMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceEnvironmentType").getter(ServiceEnvironmentDetail.getter(ServiceEnvironmentDetail::serviceEnvironmentTypeAsString)).setter(ServiceEnvironmentDetail.setter(Builder::serviceEnvironmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironmentType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ServiceEnvironmentDetail.getter(ServiceEnvironmentDetail::stateAsString)).setter(ServiceEnvironmentDetail.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ServiceEnvironmentDetail.getter(ServiceEnvironmentDetail::statusAsString)).setter(ServiceEnvironmentDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<CapacityLimit>> CAPACITY_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityLimits").getter(ServiceEnvironmentDetail.getter(ServiceEnvironmentDetail::capacityLimits)).setter(ServiceEnvironmentDetail.setter(Builder::capacityLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ServiceEnvironmentDetail.getter(ServiceEnvironmentDetail::tags)).setter(ServiceEnvironmentDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ENVIRONMENT_NAME_FIELD, SERVICE_ENVIRONMENT_ARN_FIELD, SERVICE_ENVIRONMENT_TYPE_FIELD, STATE_FIELD, STATUS_FIELD, CAPACITY_LIMITS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceEnvironmentDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceEnvironmentName;
    private final String serviceEnvironmentArn;
    private final String serviceEnvironmentType;
    private final String state;
    private final String status;
    private final List<CapacityLimit> capacityLimits;
    private final Map<String, String> tags;

    private ServiceEnvironmentDetail(BuilderImpl builder) {
        this.serviceEnvironmentName = builder.serviceEnvironmentName;
        this.serviceEnvironmentArn = builder.serviceEnvironmentArn;
        this.serviceEnvironmentType = builder.serviceEnvironmentType;
        this.state = builder.state;
        this.status = builder.status;
        this.capacityLimits = builder.capacityLimits;
        this.tags = builder.tags;
    }

    public final String serviceEnvironmentName() {
        return this.serviceEnvironmentName;
    }

    public final String serviceEnvironmentArn() {
        return this.serviceEnvironmentArn;
    }

    public final ServiceEnvironmentType serviceEnvironmentType() {
        return ServiceEnvironmentType.fromValue(this.serviceEnvironmentType);
    }

    public final String serviceEnvironmentTypeAsString() {
        return this.serviceEnvironmentType;
    }

    public final ServiceEnvironmentState state() {
        return ServiceEnvironmentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final ServiceEnvironmentStatus status() {
        return ServiceEnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasCapacityLimits() {
        return this.capacityLimits != null && !(this.capacityLimits instanceof SdkAutoConstructList);
    }

    public final List<CapacityLimit> capacityLimits() {
        return this.capacityLimits;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEnvironmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEnvironmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityLimits() ? this.capacityLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceEnvironmentDetail)) {
            return false;
        }
        ServiceEnvironmentDetail other = (ServiceEnvironmentDetail)obj;
        return Objects.equals(this.serviceEnvironmentName(), other.serviceEnvironmentName()) && Objects.equals(this.serviceEnvironmentArn(), other.serviceEnvironmentArn()) && Objects.equals(this.serviceEnvironmentTypeAsString(), other.serviceEnvironmentTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasCapacityLimits() == other.hasCapacityLimits() && Objects.equals(this.capacityLimits(), other.capacityLimits()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceEnvironmentDetail").add("ServiceEnvironmentName", (Object)this.serviceEnvironmentName()).add("ServiceEnvironmentArn", (Object)this.serviceEnvironmentArn()).add("ServiceEnvironmentType", (Object)this.serviceEnvironmentTypeAsString()).add("State", (Object)this.stateAsString()).add("Status", (Object)this.statusAsString()).add("CapacityLimits", this.hasCapacityLimits() ? this.capacityLimits() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.serviceEnvironmentName()));
            }
            case "serviceEnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.serviceEnvironmentArn()));
            }
            case "serviceEnvironmentType": {
                return Optional.ofNullable(clazz.cast(this.serviceEnvironmentTypeAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "capacityLimits": {
                return Optional.ofNullable(clazz.cast(this.capacityLimits()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceEnvironmentName", SERVICE_ENVIRONMENT_NAME_FIELD);
        map.put("serviceEnvironmentArn", SERVICE_ENVIRONMENT_ARN_FIELD);
        map.put("serviceEnvironmentType", SERVICE_ENVIRONMENT_TYPE_FIELD);
        map.put("state", STATE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("capacityLimits", CAPACITY_LIMITS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceEnvironmentDetail, T> g) {
        return obj -> g.apply((ServiceEnvironmentDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceEnvironmentName;
        private String serviceEnvironmentArn;
        private String serviceEnvironmentType;
        private String state;
        private String status;
        private List<CapacityLimit> capacityLimits = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceEnvironmentDetail model) {
            this.serviceEnvironmentName(model.serviceEnvironmentName);
            this.serviceEnvironmentArn(model.serviceEnvironmentArn);
            this.serviceEnvironmentType(model.serviceEnvironmentType);
            this.state(model.state);
            this.status(model.status);
            this.capacityLimits(model.capacityLimits);
            this.tags(model.tags);
        }

        public final String getServiceEnvironmentName() {
            return this.serviceEnvironmentName;
        }

        public final void setServiceEnvironmentName(String serviceEnvironmentName) {
            this.serviceEnvironmentName = serviceEnvironmentName;
        }

        @Override
        public final Builder serviceEnvironmentName(String serviceEnvironmentName) {
            this.serviceEnvironmentName = serviceEnvironmentName;
            return this;
        }

        public final String getServiceEnvironmentArn() {
            return this.serviceEnvironmentArn;
        }

        public final void setServiceEnvironmentArn(String serviceEnvironmentArn) {
            this.serviceEnvironmentArn = serviceEnvironmentArn;
        }

        @Override
        public final Builder serviceEnvironmentArn(String serviceEnvironmentArn) {
            this.serviceEnvironmentArn = serviceEnvironmentArn;
            return this;
        }

        public final String getServiceEnvironmentType() {
            return this.serviceEnvironmentType;
        }

        public final void setServiceEnvironmentType(String serviceEnvironmentType) {
            this.serviceEnvironmentType = serviceEnvironmentType;
        }

        @Override
        public final Builder serviceEnvironmentType(String serviceEnvironmentType) {
            this.serviceEnvironmentType = serviceEnvironmentType;
            return this;
        }

        @Override
        public final Builder serviceEnvironmentType(ServiceEnvironmentType serviceEnvironmentType) {
            this.serviceEnvironmentType(serviceEnvironmentType == null ? null : serviceEnvironmentType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ServiceEnvironmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceEnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<CapacityLimit.Builder> getCapacityLimits() {
            List<CapacityLimit.Builder> result = CapacityLimitsCopier.copyToBuilder(this.capacityLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityLimits(Collection<CapacityLimit.BuilderImpl> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copyFromBuilder(capacityLimits);
        }

        @Override
        public final Builder capacityLimits(Collection<CapacityLimit> capacityLimits) {
            this.capacityLimits = CapacityLimitsCopier.copy(capacityLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(CapacityLimit ... capacityLimits) {
            this.capacityLimits(Arrays.asList(capacityLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityLimits(Consumer<CapacityLimit.Builder> ... capacityLimits) {
            this.capacityLimits(Stream.of(capacityLimits).map(c -> (CapacityLimit)((CapacityLimit.Builder)CapacityLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public ServiceEnvironmentDetail build() {
            return new ServiceEnvironmentDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceEnvironmentDetail> {
        public Builder serviceEnvironmentName(String var1);

        public Builder serviceEnvironmentArn(String var1);

        public Builder serviceEnvironmentType(String var1);

        public Builder serviceEnvironmentType(ServiceEnvironmentType var1);

        public Builder state(String var1);

        public Builder state(ServiceEnvironmentState var1);

        public Builder status(String var1);

        public Builder status(ServiceEnvironmentStatus var1);

        public Builder capacityLimits(Collection<CapacityLimit> var1);

        public Builder capacityLimits(CapacityLimit ... var1);

        public Builder capacityLimits(Consumer<CapacityLimit.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

