/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.EksEmptyDir;
import software.amazon.awssdk.services.batch.model.EksHostPath;
import software.amazon.awssdk.services.batch.model.EksPersistentVolumeClaim;
import software.amazon.awssdk.services.batch.model.EksSecret;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksVolume> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EksVolume.getter(EksVolume::name)).setter(EksVolume.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<EksHostPath> HOST_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hostPath").getter(EksVolume.getter(EksVolume::hostPath)).setter(EksVolume.setter(Builder::hostPath)).constructor(EksHostPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPath").build()}).build();
    private static final SdkField<EksEmptyDir> EMPTY_DIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("emptyDir").getter(EksVolume.getter(EksVolume::emptyDir)).setter(EksVolume.setter(Builder::emptyDir)).constructor(EksEmptyDir::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emptyDir").build()}).build();
    private static final SdkField<EksSecret> SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("secret").getter(EksVolume.getter(EksVolume::secret)).setter(EksVolume.setter(Builder::secret)).constructor(EksSecret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secret").build()}).build();
    private static final SdkField<EksPersistentVolumeClaim> PERSISTENT_VOLUME_CLAIM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("persistentVolumeClaim").getter(EksVolume.getter(EksVolume::persistentVolumeClaim)).setter(EksVolume.setter(Builder::persistentVolumeClaim)).constructor(EksPersistentVolumeClaim::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentVolumeClaim").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOST_PATH_FIELD, EMPTY_DIR_FIELD, SECRET_FIELD, PERSISTENT_VOLUME_CLAIM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EksVolume.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final EksHostPath hostPath;
    private final EksEmptyDir emptyDir;
    private final EksSecret secret;
    private final EksPersistentVolumeClaim persistentVolumeClaim;

    private EksVolume(BuilderImpl builder) {
        this.name = builder.name;
        this.hostPath = builder.hostPath;
        this.emptyDir = builder.emptyDir;
        this.secret = builder.secret;
        this.persistentVolumeClaim = builder.persistentVolumeClaim;
    }

    public final String name() {
        return this.name;
    }

    public final EksHostPath hostPath() {
        return this.hostPath;
    }

    public final EksEmptyDir emptyDir() {
        return this.emptyDir;
    }

    public final EksSecret secret() {
        return this.secret;
    }

    public final EksPersistentVolumeClaim persistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.emptyDir());
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentVolumeClaim());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksVolume)) {
            return false;
        }
        EksVolume other = (EksVolume)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.hostPath(), other.hostPath()) && Objects.equals(this.emptyDir(), other.emptyDir()) && Objects.equals(this.secret(), other.secret()) && Objects.equals(this.persistentVolumeClaim(), other.persistentVolumeClaim());
    }

    public final String toString() {
        return ToString.builder((String)"EksVolume").add("Name", (Object)this.name()).add("HostPath", (Object)this.hostPath()).add("EmptyDir", (Object)this.emptyDir()).add("Secret", (Object)this.secret()).add("PersistentVolumeClaim", (Object)this.persistentVolumeClaim()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "hostPath": {
                return Optional.ofNullable(clazz.cast(this.hostPath()));
            }
            case "emptyDir": {
                return Optional.ofNullable(clazz.cast(this.emptyDir()));
            }
            case "secret": {
                return Optional.ofNullable(clazz.cast(this.secret()));
            }
            case "persistentVolumeClaim": {
                return Optional.ofNullable(clazz.cast(this.persistentVolumeClaim()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("hostPath", HOST_PATH_FIELD);
        map.put("emptyDir", EMPTY_DIR_FIELD);
        map.put("secret", SECRET_FIELD);
        map.put("persistentVolumeClaim", PERSISTENT_VOLUME_CLAIM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksVolume, T> g) {
        return obj -> g.apply((EksVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private EksHostPath hostPath;
        private EksEmptyDir emptyDir;
        private EksSecret secret;
        private EksPersistentVolumeClaim persistentVolumeClaim;

        private BuilderImpl() {
        }

        private BuilderImpl(EksVolume model) {
            this.name(model.name);
            this.hostPath(model.hostPath);
            this.emptyDir(model.emptyDir);
            this.secret(model.secret);
            this.persistentVolumeClaim(model.persistentVolumeClaim);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EksHostPath.Builder getHostPath() {
            return this.hostPath != null ? this.hostPath.toBuilder() : null;
        }

        public final void setHostPath(EksHostPath.BuilderImpl hostPath) {
            this.hostPath = hostPath != null ? hostPath.build() : null;
        }

        @Override
        public final Builder hostPath(EksHostPath hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        public final EksEmptyDir.Builder getEmptyDir() {
            return this.emptyDir != null ? this.emptyDir.toBuilder() : null;
        }

        public final void setEmptyDir(EksEmptyDir.BuilderImpl emptyDir) {
            this.emptyDir = emptyDir != null ? emptyDir.build() : null;
        }

        @Override
        public final Builder emptyDir(EksEmptyDir emptyDir) {
            this.emptyDir = emptyDir;
            return this;
        }

        public final EksSecret.Builder getSecret() {
            return this.secret != null ? this.secret.toBuilder() : null;
        }

        public final void setSecret(EksSecret.BuilderImpl secret) {
            this.secret = secret != null ? secret.build() : null;
        }

        @Override
        public final Builder secret(EksSecret secret) {
            this.secret = secret;
            return this;
        }

        public final EksPersistentVolumeClaim.Builder getPersistentVolumeClaim() {
            return this.persistentVolumeClaim != null ? this.persistentVolumeClaim.toBuilder() : null;
        }

        public final void setPersistentVolumeClaim(EksPersistentVolumeClaim.BuilderImpl persistentVolumeClaim) {
            this.persistentVolumeClaim = persistentVolumeClaim != null ? persistentVolumeClaim.build() : null;
        }

        @Override
        public final Builder persistentVolumeClaim(EksPersistentVolumeClaim persistentVolumeClaim) {
            this.persistentVolumeClaim = persistentVolumeClaim;
            return this;
        }

        public EksVolume build() {
            return new EksVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksVolume> {
        public Builder name(String var1);

        public Builder hostPath(EksHostPath var1);

        default public Builder hostPath(Consumer<EksHostPath.Builder> hostPath) {
            return this.hostPath((EksHostPath)((EksHostPath.Builder)EksHostPath.builder().applyMutation(hostPath)).build());
        }

        public Builder emptyDir(EksEmptyDir var1);

        default public Builder emptyDir(Consumer<EksEmptyDir.Builder> emptyDir) {
            return this.emptyDir((EksEmptyDir)((EksEmptyDir.Builder)EksEmptyDir.builder().applyMutation(emptyDir)).build());
        }

        public Builder secret(EksSecret var1);

        default public Builder secret(Consumer<EksSecret.Builder> secret) {
            return this.secret((EksSecret)((EksSecret.Builder)EksSecret.builder().applyMutation(secret)).build());
        }

        public Builder persistentVolumeClaim(EksPersistentVolumeClaim var1);

        default public Builder persistentVolumeClaim(Consumer<EksPersistentVolumeClaim.Builder> persistentVolumeClaim) {
            return this.persistentVolumeClaim((EksPersistentVolumeClaim)((EksPersistentVolumeClaim.Builder)EksPersistentVolumeClaim.builder().applyMutation(persistentVolumeClaim)).build());
        }
    }
}

