/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of containers that this task depends on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskContainerDependency implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskContainerDependency.Builder, TaskContainerDependency> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerName").getter(getter(TaskContainerDependency::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("condition").getter(getter(TaskContainerDependency::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final String condition;

    private TaskContainerDependency(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * A unique identifier for the container.
     * </p>
     * 
     * @return A unique identifier for the container.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The dependency condition of the container. The following are the available conditions and their behavior:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>START</code> - This condition emulates the behavior of links and volumes today. It validates that a
     * dependent container is started before permitting other containers to start.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits) before
     * permitting other containers to start. This can be useful for nonessential containers that run a script and then
     * exit. This condition can't be set on an essential container.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code>, but it also requires that the
     * container exits with a zero status. This condition can't be set on an essential container.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The dependency condition of the container. The following are the available conditions and their
     *         behavior:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>START</code> - This condition emulates the behavior of links and volumes today. It validates that a
     *         dependent container is started before permitting other containers to start.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits)
     *         before permitting other containers to start. This can be useful for nonessential containers that run a
     *         script and then exit. This condition can't be set on an essential container.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code>, but it also requires that the
     *         container exits with a zero status. This condition can't be set on an essential container.
     *         </p>
     *         </li>
     */
    public final String condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskContainerDependency)) {
            return false;
        }
        TaskContainerDependency other = (TaskContainerDependency) obj;
        return Objects.equals(containerName(), other.containerName()) && Objects.equals(condition(), other.condition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskContainerDependency").add("ContainerName", containerName()).add("Condition", condition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerName", CONTAINER_NAME_FIELD);
        map.put("condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskContainerDependency, T> g) {
        return obj -> g.apply((TaskContainerDependency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskContainerDependency> {
        /**
         * <p>
         * A unique identifier for the container.
         * </p>
         * 
         * @param containerName
         *        A unique identifier for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The dependency condition of the container. The following are the available conditions and their behavior:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>START</code> - This condition emulates the behavior of links and volumes today. It validates that a
         * dependent container is started before permitting other containers to start.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits) before
         * permitting other containers to start. This can be useful for nonessential containers that run a script and
         * then exit. This condition can't be set on an essential container.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code>, but it also requires that the
         * container exits with a zero status. This condition can't be set on an essential container.
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The dependency condition of the container. The following are the available conditions and their
         *        behavior:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>START</code> - This condition emulates the behavior of links and volumes today. It validates
         *        that a dependent container is started before permitting other containers to start.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> - This condition validates that a dependent container runs to completion (exits)
         *        before permitting other containers to start. This can be useful for nonessential containers that run a
         *        script and then exit. This condition can't be set on an essential container.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> - This condition is the same as <code>COMPLETE</code>, but it also requires that
         *        the container exits with a zero status. This condition can't be set on an essential container.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskContainerDependency model) {
            containerName(model.containerName);
            condition(model.condition);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public TaskContainerDependency build() {
            return new TaskContainerDependency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
