/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents summary details for the first 100 <code>RUNNABLE</code> jobs in a job queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrontOfQueueJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FrontOfQueueJobSummary.Builder, FrontOfQueueJobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(FrontOfQueueJobSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<Long> EARLIEST_TIME_AT_POSITION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("earliestTimeAtPosition").getter(getter(FrontOfQueueJobSummary::earliestTimeAtPosition))
            .setter(setter(Builder::earliestTimeAtPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("earliestTimeAtPosition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD,
            EARLIEST_TIME_AT_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobArn;

    private final Long earliestTimeAtPosition;

    private FrontOfQueueJobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.earliestTimeAtPosition = builder.earliestTimeAtPosition;
    }

    /**
     * <p>
     * The ARN for a job in a named job queue.
     * </p>
     * 
     * @return The ARN for a job in a named job queue.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job transitioned to its current position in the job queue.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the job transitioned to its current position in the job
     *         queue.
     */
    public final Long earliestTimeAtPosition() {
        return earliestTimeAtPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(earliestTimeAtPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrontOfQueueJobSummary)) {
            return false;
        }
        FrontOfQueueJobSummary other = (FrontOfQueueJobSummary) obj;
        return Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(earliestTimeAtPosition(), other.earliestTimeAtPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FrontOfQueueJobSummary").add("JobArn", jobArn())
                .add("EarliestTimeAtPosition", earliestTimeAtPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "earliestTimeAtPosition":
            return Optional.ofNullable(clazz.cast(earliestTimeAtPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("earliestTimeAtPosition", EARLIEST_TIME_AT_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FrontOfQueueJobSummary, T> g) {
        return obj -> g.apply((FrontOfQueueJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrontOfQueueJobSummary> {
        /**
         * <p>
         * The ARN for a job in a named job queue.
         * </p>
         * 
         * @param jobArn
         *        The ARN for a job in a named job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the job transitioned to its current position in the job queue.
         * </p>
         * 
         * @param earliestTimeAtPosition
         *        The Unix timestamp (in milliseconds) for when the job transitioned to its current position in the job
         *        queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestTimeAtPosition(Long earliestTimeAtPosition);
    }

    static final class BuilderImpl implements Builder {
        private String jobArn;

        private Long earliestTimeAtPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(FrontOfQueueJobSummary model) {
            jobArn(model.jobArn);
            earliestTimeAtPosition(model.earliestTimeAtPosition);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final Long getEarliestTimeAtPosition() {
            return earliestTimeAtPosition;
        }

        public final void setEarliestTimeAtPosition(Long earliestTimeAtPosition) {
            this.earliestTimeAtPosition = earliestTimeAtPosition;
        }

        @Override
        public final Builder earliestTimeAtPosition(Long earliestTimeAtPosition) {
            this.earliestTimeAtPosition = earliestTimeAtPosition;
            return this;
        }

        @Override
        public FrontOfQueueJobSummary build() {
            return new FrontOfQueueJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
