/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The security context for a job. For more information, see <a
 * href="https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a
 * pod or container</a> in the <i>Kubernetes documentation</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksContainerSecurityContext implements SdkPojo, Serializable,
        ToCopyableBuilder<EksContainerSecurityContext.Builder, EksContainerSecurityContext> {
    private static final SdkField<Long> RUN_AS_USER_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("runAsUser")
            .getter(getter(EksContainerSecurityContext::runAsUser)).setter(setter(Builder::runAsUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAsUser").build()).build();

    private static final SdkField<Long> RUN_AS_GROUP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("runAsGroup").getter(getter(EksContainerSecurityContext::runAsGroup)).setter(setter(Builder::runAsGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAsGroup").build()).build();

    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("privileged").getter(getter(EksContainerSecurityContext::privileged)).setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()).build();

    private static final SdkField<Boolean> ALLOW_PRIVILEGE_ESCALATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowPrivilegeEscalation").getter(getter(EksContainerSecurityContext::allowPrivilegeEscalation))
            .setter(setter(Builder::allowPrivilegeEscalation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowPrivilegeEscalation").build())
            .build();

    private static final SdkField<Boolean> READ_ONLY_ROOT_FILESYSTEM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readOnlyRootFilesystem").getter(getter(EksContainerSecurityContext::readOnlyRootFilesystem))
            .setter(setter(Builder::readOnlyRootFilesystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnlyRootFilesystem").build())
            .build();

    private static final SdkField<Boolean> RUN_AS_NON_ROOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("runAsNonRoot").getter(getter(EksContainerSecurityContext::runAsNonRoot))
            .setter(setter(Builder::runAsNonRoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAsNonRoot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_AS_USER_FIELD,
            RUN_AS_GROUP_FIELD, PRIVILEGED_FIELD, ALLOW_PRIVILEGE_ESCALATION_FIELD, READ_ONLY_ROOT_FILESYSTEM_FIELD,
            RUN_AS_NON_ROOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long runAsUser;

    private final Long runAsGroup;

    private final Boolean privileged;

    private final Boolean allowPrivilegeEscalation;

    private final Boolean readOnlyRootFilesystem;

    private final Boolean runAsNonRoot;

    private EksContainerSecurityContext(BuilderImpl builder) {
        this.runAsUser = builder.runAsUser;
        this.runAsGroup = builder.runAsGroup;
        this.privileged = builder.privileged;
        this.allowPrivilegeEscalation = builder.allowPrivilegeEscalation;
        this.readOnlyRootFilesystem = builder.readOnlyRootFilesystem;
        this.runAsNonRoot = builder.runAsNonRoot;
    }

    /**
     * <p>
     * When this parameter is specified, the container is run as the specified user ID (<code>uid</code>). If this
     * parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to
     * <code>RunAsUser</code> and <code>MustRanAs</code> policy in the <a
     * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod
     * security policies</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return When this parameter is specified, the container is run as the specified user ID (<code>uid</code>). If
     *         this parameter isn't specified, the default is the user that's specified in the image metadata. This
     *         parameter maps to <code>RunAsUser</code> and <code>MustRanAs</code> policy in the <a
     *         href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and
     *         groups pod security policies</a> in the <i>Kubernetes documentation</i>.
     */
    public final Long runAsUser() {
        return runAsUser;
    }

    /**
     * <p>
     * When this parameter is specified, the container is run as the specified group ID (<code>gid</code>). If this
     * parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps
     * to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the <a
     * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod
     * security policies</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return When this parameter is specified, the container is run as the specified group ID (<code>gid</code>). If
     *         this parameter isn't specified, the default is the group that's specified in the image metadata. This
     *         parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the <a
     *         href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and
     *         groups pod security policies</a> in the <i>Kubernetes documentation</i>.
     */
    public final Long runAsGroup() {
        return runAsGroup;
    }

    /**
     * <p>
     * When this parameter is <code>true</code>, the container is given elevated permissions on the host container
     * instance. The level of permissions are similar to the <code>root</code> user permissions. The default value is
     * <code>false</code>. This parameter maps to <code>privileged</code> policy in the <a
     * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged">Privileged pod security
     * policies</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return When this parameter is <code>true</code>, the container is given elevated permissions on the host
     *         container instance. The level of permissions are similar to the <code>root</code> user permissions. The
     *         default value is <code>false</code>. This parameter maps to <code>privileged</code> policy in the <a
     *         href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged">Privileged pod
     *         security policies</a> in the <i>Kubernetes documentation</i>.
     */
    public final Boolean privileged() {
        return privileged;
    }

    /**
     * <p>
     * Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process. The
     * default value is <code>false</code>.
     * </p>
     * 
     * @return Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent
     *         process. The default value is <code>false</code>.
     */
    public final Boolean allowPrivilegeEscalation() {
        return allowPrivilegeEscalation;
    }

    /**
     * <p>
     * When this parameter is <code>true</code>, the container is given read-only access to its root file system. The
     * default value is <code>false</code>. This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the <a
     * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">Volumes and
     * file systems pod security policies</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return When this parameter is <code>true</code>, the container is given read-only access to its root file
     *         system. The default value is <code>false</code>. This parameter maps to
     *         <code>ReadOnlyRootFilesystem</code> policy in the <a
     *         href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">Volumes
     *         and file systems pod security policies</a> in the <i>Kubernetes documentation</i>.
     */
    public final Boolean readOnlyRootFilesystem() {
        return readOnlyRootFilesystem;
    }

    /**
     * <p>
     * When this parameter is specified, the container is run as a user with a <code>uid</code> other than 0. If this
     * parameter isn't specified, so such rule is enforced. This parameter maps to <code>RunAsUser</code> and
     * <code>MustRunAsNonRoot</code> policy in the <a
     * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod
     * security policies</a> in the <i>Kubernetes documentation</i>.
     * </p>
     * 
     * @return When this parameter is specified, the container is run as a user with a <code>uid</code> other than 0. If
     *         this parameter isn't specified, so such rule is enforced. This parameter maps to <code>RunAsUser</code>
     *         and <code>MustRunAsNonRoot</code> policy in the <a
     *         href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and
     *         groups pod security policies</a> in the <i>Kubernetes documentation</i>.
     */
    public final Boolean runAsNonRoot() {
        return runAsNonRoot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(runAsGroup());
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        hashCode = 31 * hashCode + Objects.hashCode(allowPrivilegeEscalation());
        hashCode = 31 * hashCode + Objects.hashCode(readOnlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(runAsNonRoot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksContainerSecurityContext)) {
            return false;
        }
        EksContainerSecurityContext other = (EksContainerSecurityContext) obj;
        return Objects.equals(runAsUser(), other.runAsUser()) && Objects.equals(runAsGroup(), other.runAsGroup())
                && Objects.equals(privileged(), other.privileged())
                && Objects.equals(allowPrivilegeEscalation(), other.allowPrivilegeEscalation())
                && Objects.equals(readOnlyRootFilesystem(), other.readOnlyRootFilesystem())
                && Objects.equals(runAsNonRoot(), other.runAsNonRoot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksContainerSecurityContext").add("RunAsUser", runAsUser()).add("RunAsGroup", runAsGroup())
                .add("Privileged", privileged()).add("AllowPrivilegeEscalation", allowPrivilegeEscalation())
                .add("ReadOnlyRootFilesystem", readOnlyRootFilesystem()).add("RunAsNonRoot", runAsNonRoot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runAsUser":
            return Optional.ofNullable(clazz.cast(runAsUser()));
        case "runAsGroup":
            return Optional.ofNullable(clazz.cast(runAsGroup()));
        case "privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        case "allowPrivilegeEscalation":
            return Optional.ofNullable(clazz.cast(allowPrivilegeEscalation()));
        case "readOnlyRootFilesystem":
            return Optional.ofNullable(clazz.cast(readOnlyRootFilesystem()));
        case "runAsNonRoot":
            return Optional.ofNullable(clazz.cast(runAsNonRoot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("runAsUser", RUN_AS_USER_FIELD);
        map.put("runAsGroup", RUN_AS_GROUP_FIELD);
        map.put("privileged", PRIVILEGED_FIELD);
        map.put("allowPrivilegeEscalation", ALLOW_PRIVILEGE_ESCALATION_FIELD);
        map.put("readOnlyRootFilesystem", READ_ONLY_ROOT_FILESYSTEM_FIELD);
        map.put("runAsNonRoot", RUN_AS_NON_ROOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksContainerSecurityContext, T> g) {
        return obj -> g.apply((EksContainerSecurityContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksContainerSecurityContext> {
        /**
         * <p>
         * When this parameter is specified, the container is run as the specified user ID (<code>uid</code>). If this
         * parameter isn't specified, the default is the user that's specified in the image metadata. This parameter
         * maps to <code>RunAsUser</code> and <code>MustRanAs</code> policy in the <a
         * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups
         * pod security policies</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param runAsUser
         *        When this parameter is specified, the container is run as the specified user ID (<code>uid</code>). If
         *        this parameter isn't specified, the default is the user that's specified in the image metadata. This
         *        parameter maps to <code>RunAsUser</code> and <code>MustRanAs</code> policy in the <a
         *        href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and
         *        groups pod security policies</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runAsUser(Long runAsUser);

        /**
         * <p>
         * When this parameter is specified, the container is run as the specified group ID (<code>gid</code>). If this
         * parameter isn't specified, the default is the group that's specified in the image metadata. This parameter
         * maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the <a
         * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups
         * pod security policies</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param runAsGroup
         *        When this parameter is specified, the container is run as the specified group ID (<code>gid</code>).
         *        If this parameter isn't specified, the default is the group that's specified in the image metadata.
         *        This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the <a
         *        href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and
         *        groups pod security policies</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runAsGroup(Long runAsGroup);

        /**
         * <p>
         * When this parameter is <code>true</code>, the container is given elevated permissions on the host container
         * instance. The level of permissions are similar to the <code>root</code> user permissions. The default value
         * is <code>false</code>. This parameter maps to <code>privileged</code> policy in the <a
         * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged">Privileged pod security
         * policies</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param privileged
         *        When this parameter is <code>true</code>, the container is given elevated permissions on the host
         *        container instance. The level of permissions are similar to the <code>root</code> user permissions.
         *        The default value is <code>false</code>. This parameter maps to <code>privileged</code> policy in the
         *        <a href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged">Privileged pod
         *        security policies</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);

        /**
         * <p>
         * Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process.
         * The default value is <code>false</code>.
         * </p>
         * 
         * @param allowPrivilegeEscalation
         *        Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent
         *        process. The default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowPrivilegeEscalation(Boolean allowPrivilegeEscalation);

        /**
         * <p>
         * When this parameter is <code>true</code>, the container is given read-only access to its root file system.
         * The default value is <code>false</code>. This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in
         * the <a
         * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">Volumes and
         * file systems pod security policies</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param readOnlyRootFilesystem
         *        When this parameter is <code>true</code>, the container is given read-only access to its root file
         *        system. The default value is <code>false</code>. This parameter maps to
         *        <code>ReadOnlyRootFilesystem</code> policy in the <a
         *        href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems"
         *        >Volumes and file systems pod security policies</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnlyRootFilesystem(Boolean readOnlyRootFilesystem);

        /**
         * <p>
         * When this parameter is specified, the container is run as a user with a <code>uid</code> other than 0. If
         * this parameter isn't specified, so such rule is enforced. This parameter maps to <code>RunAsUser</code> and
         * <code>MustRunAsNonRoot</code> policy in the <a
         * href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups
         * pod security policies</a> in the <i>Kubernetes documentation</i>.
         * </p>
         * 
         * @param runAsNonRoot
         *        When this parameter is specified, the container is run as a user with a <code>uid</code> other than 0.
         *        If this parameter isn't specified, so such rule is enforced. This parameter maps to
         *        <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the <a
         *        href="https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and
         *        groups pod security policies</a> in the <i>Kubernetes documentation</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runAsNonRoot(Boolean runAsNonRoot);
    }

    static final class BuilderImpl implements Builder {
        private Long runAsUser;

        private Long runAsGroup;

        private Boolean privileged;

        private Boolean allowPrivilegeEscalation;

        private Boolean readOnlyRootFilesystem;

        private Boolean runAsNonRoot;

        private BuilderImpl() {
        }

        private BuilderImpl(EksContainerSecurityContext model) {
            runAsUser(model.runAsUser);
            runAsGroup(model.runAsGroup);
            privileged(model.privileged);
            allowPrivilegeEscalation(model.allowPrivilegeEscalation);
            readOnlyRootFilesystem(model.readOnlyRootFilesystem);
            runAsNonRoot(model.runAsNonRoot);
        }

        public final Long getRunAsUser() {
            return runAsUser;
        }

        public final void setRunAsUser(Long runAsUser) {
            this.runAsUser = runAsUser;
        }

        @Override
        public final Builder runAsUser(Long runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        public final Long getRunAsGroup() {
            return runAsGroup;
        }

        public final void setRunAsGroup(Long runAsGroup) {
            this.runAsGroup = runAsGroup;
        }

        @Override
        public final Builder runAsGroup(Long runAsGroup) {
            this.runAsGroup = runAsGroup;
            return this;
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Boolean getAllowPrivilegeEscalation() {
            return allowPrivilegeEscalation;
        }

        public final void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        }

        @Override
        public final Builder allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
            return this;
        }

        public final Boolean getReadOnlyRootFilesystem() {
            return readOnlyRootFilesystem;
        }

        public final void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
            this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        }

        @Override
        public final Builder readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
            this.readOnlyRootFilesystem = readOnlyRootFilesystem;
            return this;
        }

        public final Boolean getRunAsNonRoot() {
            return runAsNonRoot;
        }

        public final void setRunAsNonRoot(Boolean runAsNonRoot) {
            this.runAsNonRoot = runAsNonRoot;
        }

        @Override
        public final Builder runAsNonRoot(Boolean runAsNonRoot) {
            this.runAsNonRoot = runAsNonRoot;
            return this;
        }

        @Override
        public EksContainerSecurityContext build() {
            return new EksContainerSecurityContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
