/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.EphemeralStorage;
import software.amazon.awssdk.services.batch.model.FargatePlatformConfiguration;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.services.batch.model.LinuxParameters;
import software.amazon.awssdk.services.batch.model.LogConfiguration;
import software.amazon.awssdk.services.batch.model.MountPoint;
import software.amazon.awssdk.services.batch.model.MountPointsCopier;
import software.amazon.awssdk.services.batch.model.NetworkConfiguration;
import software.amazon.awssdk.services.batch.model.NetworkInterface;
import software.amazon.awssdk.services.batch.model.NetworkInterfaceListCopier;
import software.amazon.awssdk.services.batch.model.RepositoryCredentials;
import software.amazon.awssdk.services.batch.model.ResourceRequirement;
import software.amazon.awssdk.services.batch.model.ResourceRequirementsCopier;
import software.amazon.awssdk.services.batch.model.RuntimePlatform;
import software.amazon.awssdk.services.batch.model.Secret;
import software.amazon.awssdk.services.batch.model.SecretListCopier;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.Ulimit;
import software.amazon.awssdk.services.batch.model.UlimitsCopier;
import software.amazon.awssdk.services.batch.model.Volume;
import software.amazon.awssdk.services.batch.model.VolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDetail> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ContainerDetail.getter(ContainerDetail::image)).setter(ContainerDetail.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<Integer> VCPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vcpus").getter(ContainerDetail.getter(ContainerDetail::vcpus)).setter(ContainerDetail.setter(Builder::vcpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcpus").build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(ContainerDetail.getter(ContainerDetail::memory)).setter(ContainerDetail.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(ContainerDetail.getter(ContainerDetail::command)).setter(ContainerDetail.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobRoleArn").getter(ContainerDetail.getter(ContainerDetail::jobRoleArn)).setter(ContainerDetail.setter(Builder::jobRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRoleArn").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(ContainerDetail.getter(ContainerDetail::executionRoleArn)).setter(ContainerDetail.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumes").getter(ContainerDetail.getter(ContainerDetail::volumes)).setter(ContainerDetail.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environment").getter(ContainerDetail.getter(ContainerDetail::environment)).setter(ContainerDetail.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MountPoint>> MOUNT_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mountPoints").getter(ContainerDetail.getter(ContainerDetail::mountPoints)).setter(ContainerDetail.setter(Builder::mountPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MountPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> READONLY_ROOT_FILESYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readonlyRootFilesystem").getter(ContainerDetail.getter(ContainerDetail::readonlyRootFilesystem)).setter(ContainerDetail.setter(Builder::readonlyRootFilesystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyRootFilesystem").build()}).build();
    private static final SdkField<List<Ulimit>> ULIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ulimits").getter(ContainerDetail.getter(ContainerDetail::ulimits)).setter(ContainerDetail.setter(Builder::ulimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ulimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ulimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privileged").getter(ContainerDetail.getter(ContainerDetail::privileged)).setter(ContainerDetail.setter(Builder::privileged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("user").getter(ContainerDetail.getter(ContainerDetail::user)).setter(ContainerDetail.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("exitCode").getter(ContainerDetail.getter(ContainerDetail::exitCode)).setter(ContainerDetail.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(ContainerDetail.getter(ContainerDetail::reason)).setter(ContainerDetail.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerInstanceArn").getter(ContainerDetail.getter(ContainerDetail::containerInstanceArn)).setter(ContainerDetail.setter(Builder::containerInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskArn").getter(ContainerDetail.getter(ContainerDetail::taskArn)).setter(ContainerDetail.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamName").getter(ContainerDetail.getter(ContainerDetail::logStreamName)).setter(ContainerDetail.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(ContainerDetail.getter(ContainerDetail::instanceType)).setter(ContainerDetail.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfaces").getter(ContainerDetail.getter(ContainerDetail::networkInterfaces)).setter(ContainerDetail.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceRequirements").getter(ContainerDetail.getter(ContainerDetail::resourceRequirements)).setter(ContainerDetail.setter(Builder::resourceRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LinuxParameters> LINUX_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("linuxParameters").getter(ContainerDetail.getter(ContainerDetail::linuxParameters)).setter(ContainerDetail.setter(Builder::linuxParameters)).constructor(LinuxParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxParameters").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(ContainerDetail.getter(ContainerDetail::logConfiguration)).setter(ContainerDetail.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<List<Secret>> SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secrets").getter(ContainerDetail.getter(ContainerDetail::secrets)).setter(ContainerDetail.setter(Builder::secrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secrets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Secret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(ContainerDetail.getter(ContainerDetail::networkConfiguration)).setter(ContainerDetail.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<FargatePlatformConfiguration> FARGATE_PLATFORM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fargatePlatformConfiguration").getter(ContainerDetail.getter(ContainerDetail::fargatePlatformConfiguration)).setter(ContainerDetail.setter(Builder::fargatePlatformConfiguration)).constructor(FargatePlatformConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargatePlatformConfiguration").build()}).build();
    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ephemeralStorage").getter(ContainerDetail.getter(ContainerDetail::ephemeralStorage)).setter(ContainerDetail.setter(Builder::ephemeralStorage)).constructor(EphemeralStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeralStorage").build()}).build();
    private static final SdkField<RuntimePlatform> RUNTIME_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runtimePlatform").getter(ContainerDetail.getter(ContainerDetail::runtimePlatform)).setter(ContainerDetail.setter(Builder::runtimePlatform)).constructor(RuntimePlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimePlatform").build()}).build();
    private static final SdkField<RepositoryCredentials> REPOSITORY_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repositoryCredentials").getter(ContainerDetail.getter(ContainerDetail::repositoryCredentials)).setter(ContainerDetail.setter(Builder::repositoryCredentials)).constructor(RepositoryCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCredentials").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, VCPUS_FIELD, MEMORY_FIELD, COMMAND_FIELD, JOB_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD, VOLUMES_FIELD, ENVIRONMENT_FIELD, MOUNT_POINTS_FIELD, READONLY_ROOT_FILESYSTEM_FIELD, ULIMITS_FIELD, PRIVILEGED_FIELD, USER_FIELD, EXIT_CODE_FIELD, REASON_FIELD, CONTAINER_INSTANCE_ARN_FIELD, TASK_ARN_FIELD, LOG_STREAM_NAME_FIELD, INSTANCE_TYPE_FIELD, NETWORK_INTERFACES_FIELD, RESOURCE_REQUIREMENTS_FIELD, LINUX_PARAMETERS_FIELD, LOG_CONFIGURATION_FIELD, SECRETS_FIELD, NETWORK_CONFIGURATION_FIELD, FARGATE_PLATFORM_CONFIGURATION_FIELD, EPHEMERAL_STORAGE_FIELD, RUNTIME_PLATFORM_FIELD, REPOSITORY_CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("image", IMAGE_FIELD);
            this.put("vcpus", VCPUS_FIELD);
            this.put("memory", MEMORY_FIELD);
            this.put("command", COMMAND_FIELD);
            this.put("jobRoleArn", JOB_ROLE_ARN_FIELD);
            this.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("volumes", VOLUMES_FIELD);
            this.put("environment", ENVIRONMENT_FIELD);
            this.put("mountPoints", MOUNT_POINTS_FIELD);
            this.put("readonlyRootFilesystem", READONLY_ROOT_FILESYSTEM_FIELD);
            this.put("ulimits", ULIMITS_FIELD);
            this.put("privileged", PRIVILEGED_FIELD);
            this.put("user", USER_FIELD);
            this.put("exitCode", EXIT_CODE_FIELD);
            this.put("reason", REASON_FIELD);
            this.put("containerInstanceArn", CONTAINER_INSTANCE_ARN_FIELD);
            this.put("taskArn", TASK_ARN_FIELD);
            this.put("logStreamName", LOG_STREAM_NAME_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
            this.put("networkInterfaces", NETWORK_INTERFACES_FIELD);
            this.put("resourceRequirements", RESOURCE_REQUIREMENTS_FIELD);
            this.put("linuxParameters", LINUX_PARAMETERS_FIELD);
            this.put("logConfiguration", LOG_CONFIGURATION_FIELD);
            this.put("secrets", SECRETS_FIELD);
            this.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
            this.put("fargatePlatformConfiguration", FARGATE_PLATFORM_CONFIGURATION_FIELD);
            this.put("ephemeralStorage", EPHEMERAL_STORAGE_FIELD);
            this.put("runtimePlatform", RUNTIME_PLATFORM_FIELD);
            this.put("repositoryCredentials", REPOSITORY_CREDENTIALS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String image;
    private final Integer vcpus;
    private final Integer memory;
    private final List<String> command;
    private final String jobRoleArn;
    private final String executionRoleArn;
    private final List<Volume> volumes;
    private final List<KeyValuePair> environment;
    private final List<MountPoint> mountPoints;
    private final Boolean readonlyRootFilesystem;
    private final List<Ulimit> ulimits;
    private final Boolean privileged;
    private final String user;
    private final Integer exitCode;
    private final String reason;
    private final String containerInstanceArn;
    private final String taskArn;
    private final String logStreamName;
    private final String instanceType;
    private final List<NetworkInterface> networkInterfaces;
    private final List<ResourceRequirement> resourceRequirements;
    private final LinuxParameters linuxParameters;
    private final LogConfiguration logConfiguration;
    private final List<Secret> secrets;
    private final NetworkConfiguration networkConfiguration;
    private final FargatePlatformConfiguration fargatePlatformConfiguration;
    private final EphemeralStorage ephemeralStorage;
    private final RuntimePlatform runtimePlatform;
    private final RepositoryCredentials repositoryCredentials;

    private ContainerDetail(BuilderImpl builder) {
        this.image = builder.image;
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.jobRoleArn = builder.jobRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.volumes = builder.volumes;
        this.environment = builder.environment;
        this.mountPoints = builder.mountPoints;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.ulimits = builder.ulimits;
        this.privileged = builder.privileged;
        this.user = builder.user;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.logStreamName = builder.logStreamName;
        this.instanceType = builder.instanceType;
        this.networkInterfaces = builder.networkInterfaces;
        this.resourceRequirements = builder.resourceRequirements;
        this.linuxParameters = builder.linuxParameters;
        this.logConfiguration = builder.logConfiguration;
        this.secrets = builder.secrets;
        this.networkConfiguration = builder.networkConfiguration;
        this.fargatePlatformConfiguration = builder.fargatePlatformConfiguration;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.runtimePlatform = builder.runtimePlatform;
        this.repositoryCredentials = builder.repositoryCredentials;
    }

    public final String image() {
        return this.image;
    }

    public final Integer vcpus() {
        return this.vcpus;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final String jobRoleArn() {
        return this.jobRoleArn;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<Volume> volumes() {
        return this.volumes;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> environment() {
        return this.environment;
    }

    public final boolean hasMountPoints() {
        return this.mountPoints != null && !(this.mountPoints instanceof SdkAutoConstructList);
    }

    public final List<MountPoint> mountPoints() {
        return this.mountPoints;
    }

    public final Boolean readonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public final boolean hasUlimits() {
        return this.ulimits != null && !(this.ulimits instanceof SdkAutoConstructList);
    }

    public final List<Ulimit> ulimits() {
        return this.ulimits;
    }

    public final Boolean privileged() {
        return this.privileged;
    }

    public final String user() {
        return this.user;
    }

    public final Integer exitCode() {
        return this.exitCode;
    }

    public final String reason() {
        return this.reason;
    }

    public final String containerInstanceArn() {
        return this.containerInstanceArn;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final String logStreamName() {
        return this.logStreamName;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final boolean hasResourceRequirements() {
        return this.resourceRequirements != null && !(this.resourceRequirements instanceof SdkAutoConstructList);
    }

    public final List<ResourceRequirement> resourceRequirements() {
        return this.resourceRequirements;
    }

    public final LinuxParameters linuxParameters() {
        return this.linuxParameters;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final boolean hasSecrets() {
        return this.secrets != null && !(this.secrets instanceof SdkAutoConstructList);
    }

    public final List<Secret> secrets() {
        return this.secrets;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final FargatePlatformConfiguration fargatePlatformConfiguration() {
        return this.fargatePlatformConfiguration;
    }

    public final EphemeralStorage ephemeralStorage() {
        return this.ephemeralStorage;
    }

    public final RuntimePlatform runtimePlatform() {
        return this.runtimePlatform;
    }

    public final RepositoryCredentials repositoryCredentials() {
        return this.repositoryCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMountPoints() ? this.mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.readonlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUlimits() ? this.ulimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRequirements() ? this.resourceRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecrets() ? this.secrets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fargatePlatformConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimePlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryCredentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDetail)) {
            return false;
        }
        ContainerDetail other = (ContainerDetail)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.vcpus(), other.vcpus()) && Objects.equals(this.memory(), other.memory()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && Objects.equals(this.jobRoleArn(), other.jobRoleArn()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && this.hasMountPoints() == other.hasMountPoints() && Objects.equals(this.mountPoints(), other.mountPoints()) && Objects.equals(this.readonlyRootFilesystem(), other.readonlyRootFilesystem()) && this.hasUlimits() == other.hasUlimits() && Objects.equals(this.ulimits(), other.ulimits()) && Objects.equals(this.privileged(), other.privileged()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.containerInstanceArn(), other.containerInstanceArn()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.instanceType(), other.instanceType()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && this.hasResourceRequirements() == other.hasResourceRequirements() && Objects.equals(this.resourceRequirements(), other.resourceRequirements()) && Objects.equals(this.linuxParameters(), other.linuxParameters()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && this.hasSecrets() == other.hasSecrets() && Objects.equals(this.secrets(), other.secrets()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.fargatePlatformConfiguration(), other.fargatePlatformConfiguration()) && Objects.equals(this.ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(this.runtimePlatform(), other.runtimePlatform()) && Objects.equals(this.repositoryCredentials(), other.repositoryCredentials());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerDetail").add("Image", (Object)this.image()).add("Vcpus", (Object)this.vcpus()).add("Memory", (Object)this.memory()).add("Command", this.hasCommand() ? this.command() : null).add("JobRoleArn", (Object)this.jobRoleArn()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("MountPoints", this.hasMountPoints() ? this.mountPoints() : null).add("ReadonlyRootFilesystem", (Object)this.readonlyRootFilesystem()).add("Ulimits", this.hasUlimits() ? this.ulimits() : null).add("Privileged", (Object)this.privileged()).add("User", (Object)this.user()).add("ExitCode", (Object)this.exitCode()).add("Reason", (Object)this.reason()).add("ContainerInstanceArn", (Object)this.containerInstanceArn()).add("TaskArn", (Object)this.taskArn()).add("LogStreamName", (Object)this.logStreamName()).add("InstanceType", (Object)this.instanceType()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("ResourceRequirements", this.hasResourceRequirements() ? this.resourceRequirements() : null).add("LinuxParameters", (Object)this.linuxParameters()).add("LogConfiguration", (Object)this.logConfiguration()).add("Secrets", this.hasSecrets() ? this.secrets() : null).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("FargatePlatformConfiguration", (Object)this.fargatePlatformConfiguration()).add("EphemeralStorage", (Object)this.ephemeralStorage()).add("RuntimePlatform", (Object)this.runtimePlatform()).add("RepositoryCredentials", (Object)this.repositoryCredentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "vcpus": {
                return Optional.ofNullable(clazz.cast(this.vcpus()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "jobRoleArn": {
                return Optional.ofNullable(clazz.cast(this.jobRoleArn()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "mountPoints": {
                return Optional.ofNullable(clazz.cast(this.mountPoints()));
            }
            case "readonlyRootFilesystem": {
                return Optional.ofNullable(clazz.cast(this.readonlyRootFilesystem()));
            }
            case "ulimits": {
                return Optional.ofNullable(clazz.cast(this.ulimits()));
            }
            case "privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "containerInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArn()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "networkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "resourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.resourceRequirements()));
            }
            case "linuxParameters": {
                return Optional.ofNullable(clazz.cast(this.linuxParameters()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "secrets": {
                return Optional.ofNullable(clazz.cast(this.secrets()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "fargatePlatformConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fargatePlatformConfiguration()));
            }
            case "ephemeralStorage": {
                return Optional.ofNullable(clazz.cast(this.ephemeralStorage()));
            }
            case "runtimePlatform": {
                return Optional.ofNullable(clazz.cast(this.runtimePlatform()));
            }
            case "repositoryCredentials": {
                return Optional.ofNullable(clazz.cast(this.repositoryCredentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDetail, T> g) {
        return obj -> g.apply((ContainerDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private Integer vcpus;
        private Integer memory;
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private String jobRoleArn;
        private String executionRoleArn;
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();
        private List<MountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();
        private Boolean readonlyRootFilesystem;
        private List<Ulimit> ulimits = DefaultSdkAutoConstructList.getInstance();
        private Boolean privileged;
        private String user;
        private Integer exitCode;
        private String reason;
        private String containerInstanceArn;
        private String taskArn;
        private String logStreamName;
        private String instanceType;
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();
        private LinuxParameters linuxParameters;
        private LogConfiguration logConfiguration;
        private List<Secret> secrets = DefaultSdkAutoConstructList.getInstance();
        private NetworkConfiguration networkConfiguration;
        private FargatePlatformConfiguration fargatePlatformConfiguration;
        private EphemeralStorage ephemeralStorage;
        private RuntimePlatform runtimePlatform;
        private RepositoryCredentials repositoryCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDetail model) {
            this.image(model.image);
            this.vcpus(model.vcpus);
            this.memory(model.memory);
            this.command(model.command);
            this.jobRoleArn(model.jobRoleArn);
            this.executionRoleArn(model.executionRoleArn);
            this.volumes(model.volumes);
            this.environment(model.environment);
            this.mountPoints(model.mountPoints);
            this.readonlyRootFilesystem(model.readonlyRootFilesystem);
            this.ulimits(model.ulimits);
            this.privileged(model.privileged);
            this.user(model.user);
            this.exitCode(model.exitCode);
            this.reason(model.reason);
            this.containerInstanceArn(model.containerInstanceArn);
            this.taskArn(model.taskArn);
            this.logStreamName(model.logStreamName);
            this.instanceType(model.instanceType);
            this.networkInterfaces(model.networkInterfaces);
            this.resourceRequirements(model.resourceRequirements);
            this.linuxParameters(model.linuxParameters);
            this.logConfiguration(model.logConfiguration);
            this.secrets(model.secrets);
            this.networkConfiguration(model.networkConfiguration);
            this.fargatePlatformConfiguration(model.fargatePlatformConfiguration);
            this.ephemeralStorage(model.ephemeralStorage);
            this.runtimePlatform(model.runtimePlatform);
            this.repositoryCredentials(model.repositoryCredentials);
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final Integer getVcpus() {
            return this.vcpus;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final String getJobRoleArn() {
            return this.jobRoleArn;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KeyValuePair.Builder> getEnvironment() {
            List<KeyValuePair.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MountPoint.Builder> getMountPoints() {
            List<MountPoint.Builder> result = MountPointsCopier.copyToBuilder(this.mountPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMountPoints(Collection<MountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = MountPointsCopier.copyFromBuilder(mountPoints);
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<MountPoint.Builder> ... mountPoints) {
            this.mountPoints(Stream.of(mountPoints).map(c -> (MountPoint)((MountPoint.Builder)MountPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final List<Ulimit.Builder> getUlimits() {
            List<Ulimit.Builder> result = UlimitsCopier.copyToBuilder(this.ulimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUlimits(Collection<Ulimit.BuilderImpl> ulimits) {
            this.ulimits = UlimitsCopier.copyFromBuilder(ulimits);
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit ... ulimits) {
            this.ulimits(Arrays.asList(ulimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Consumer<Ulimit.Builder> ... ulimits) {
            this.ulimits(Stream.of(ulimits).map(c -> (Ulimit)((Ulimit.Builder)Ulimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getContainerInstanceArn() {
            return this.containerInstanceArn;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfaceListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceRequirement.Builder> getResourceRequirements() {
            List<ResourceRequirement.Builder> result = ResourceRequirementsCopier.copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<ResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(ResourceRequirement ... resourceRequirements) {
            this.resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... resourceRequirements) {
            this.resourceRequirements(Stream.of(resourceRequirements).map(c -> (ResourceRequirement)((ResourceRequirement.Builder)ResourceRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LinuxParameters.Builder getLinuxParameters() {
            return this.linuxParameters != null ? this.linuxParameters.toBuilder() : null;
        }

        public final void setLinuxParameters(LinuxParameters.BuilderImpl linuxParameters) {
            this.linuxParameters = linuxParameters != null ? linuxParameters.build() : null;
        }

        @Override
        public final Builder linuxParameters(LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final List<Secret.Builder> getSecrets() {
            List<Secret.Builder> result = SecretListCopier.copyToBuilder(this.secrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecrets(Collection<Secret.BuilderImpl> secrets) {
            this.secrets = SecretListCopier.copyFromBuilder(secrets);
        }

        @Override
        public final Builder secrets(Collection<Secret> secrets) {
            this.secrets = SecretListCopier.copy(secrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Secret ... secrets) {
            this.secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Consumer<Secret.Builder> ... secrets) {
            this.secrets(Stream.of(secrets).map(c -> (Secret)((Secret.Builder)Secret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final FargatePlatformConfiguration.Builder getFargatePlatformConfiguration() {
            return this.fargatePlatformConfiguration != null ? this.fargatePlatformConfiguration.toBuilder() : null;
        }

        public final void setFargatePlatformConfiguration(FargatePlatformConfiguration.BuilderImpl fargatePlatformConfiguration) {
            this.fargatePlatformConfiguration = fargatePlatformConfiguration != null ? fargatePlatformConfiguration.build() : null;
        }

        @Override
        public final Builder fargatePlatformConfiguration(FargatePlatformConfiguration fargatePlatformConfiguration) {
            this.fargatePlatformConfiguration = fargatePlatformConfiguration;
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return this.ephemeralStorage != null ? this.ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final RuntimePlatform.Builder getRuntimePlatform() {
            return this.runtimePlatform != null ? this.runtimePlatform.toBuilder() : null;
        }

        public final void setRuntimePlatform(RuntimePlatform.BuilderImpl runtimePlatform) {
            this.runtimePlatform = runtimePlatform != null ? runtimePlatform.build() : null;
        }

        @Override
        public final Builder runtimePlatform(RuntimePlatform runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        public final RepositoryCredentials.Builder getRepositoryCredentials() {
            return this.repositoryCredentials != null ? this.repositoryCredentials.toBuilder() : null;
        }

        public final void setRepositoryCredentials(RepositoryCredentials.BuilderImpl repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials != null ? repositoryCredentials.build() : null;
        }

        @Override
        public final Builder repositoryCredentials(RepositoryCredentials repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        public ContainerDetail build() {
            return new ContainerDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDetail> {
        public Builder image(String var1);

        public Builder vcpus(Integer var1);

        public Builder memory(Integer var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder jobRoleArn(String var1);

        public Builder executionRoleArn(String var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder environment(Consumer<KeyValuePair.Builder> ... var1);

        public Builder mountPoints(Collection<MountPoint> var1);

        public Builder mountPoints(MountPoint ... var1);

        public Builder mountPoints(Consumer<MountPoint.Builder> ... var1);

        public Builder readonlyRootFilesystem(Boolean var1);

        public Builder ulimits(Collection<Ulimit> var1);

        public Builder ulimits(Ulimit ... var1);

        public Builder ulimits(Consumer<Ulimit.Builder> ... var1);

        public Builder privileged(Boolean var1);

        public Builder user(String var1);

        public Builder exitCode(Integer var1);

        public Builder reason(String var1);

        public Builder containerInstanceArn(String var1);

        public Builder taskArn(String var1);

        public Builder logStreamName(String var1);

        public Builder instanceType(String var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder resourceRequirements(Collection<ResourceRequirement> var1);

        public Builder resourceRequirements(ResourceRequirement ... var1);

        public Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... var1);

        public Builder linuxParameters(LinuxParameters var1);

        default public Builder linuxParameters(Consumer<LinuxParameters.Builder> linuxParameters) {
            return this.linuxParameters((LinuxParameters)((LinuxParameters.Builder)LinuxParameters.builder().applyMutation(linuxParameters)).build());
        }

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder secrets(Collection<Secret> var1);

        public Builder secrets(Secret ... var1);

        public Builder secrets(Consumer<Secret.Builder> ... var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder fargatePlatformConfiguration(FargatePlatformConfiguration var1);

        default public Builder fargatePlatformConfiguration(Consumer<FargatePlatformConfiguration.Builder> fargatePlatformConfiguration) {
            return this.fargatePlatformConfiguration((FargatePlatformConfiguration)((FargatePlatformConfiguration.Builder)FargatePlatformConfiguration.builder().applyMutation(fargatePlatformConfiguration)).build());
        }

        public Builder ephemeralStorage(EphemeralStorage var1);

        default public Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return this.ephemeralStorage((EphemeralStorage)((EphemeralStorage.Builder)EphemeralStorage.builder().applyMutation(ephemeralStorage)).build());
        }

        public Builder runtimePlatform(RuntimePlatform var1);

        default public Builder runtimePlatform(Consumer<RuntimePlatform.Builder> runtimePlatform) {
            return this.runtimePlatform((RuntimePlatform)((RuntimePlatform.Builder)RuntimePlatform.builder().applyMutation(runtimePlatform)).build());
        }

        public Builder repositoryCredentials(RepositoryCredentials var1);

        default public Builder repositoryCredentials(Consumer<RepositoryCredentials.Builder> repositoryCredentials) {
            return this.repositoryCredentials((RepositoryCredentials)((RepositoryCredentials.Builder)RepositoryCredentials.builder().applyMutation(repositoryCredentials)).build());
        }
    }
}

