/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.AttemptContainerDetail;
import software.amazon.awssdk.services.batch.model.AttemptEcsTaskDetails;
import software.amazon.awssdk.services.batch.model.ListAttemptEcsTaskDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttemptDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttemptDetail> {
    private static final SdkField<AttemptContainerDetail> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("container").getter(AttemptDetail.getter(AttemptDetail::container)).setter(AttemptDetail.setter(Builder::container)).constructor(AttemptContainerDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(AttemptDetail.getter(AttemptDetail::startedAt)).setter(AttemptDetail.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("stoppedAt").getter(AttemptDetail.getter(AttemptDetail::stoppedAt)).setter(AttemptDetail.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(AttemptDetail.getter(AttemptDetail::statusReason)).setter(AttemptDetail.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<List<AttemptEcsTaskDetails>> TASK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskProperties").getter(AttemptDetail.getter(AttemptDetail::taskProperties)).setter(AttemptDetail.setter(Builder::taskProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttemptEcsTaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD, STATUS_REASON_FIELD, TASK_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("container", CONTAINER_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("stoppedAt", STOPPED_AT_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
            this.put("taskProperties", TASK_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AttemptContainerDetail container;
    private final Long startedAt;
    private final Long stoppedAt;
    private final String statusReason;
    private final List<AttemptEcsTaskDetails> taskProperties;

    private AttemptDetail(BuilderImpl builder) {
        this.container = builder.container;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
        this.taskProperties = builder.taskProperties;
    }

    public final AttemptContainerDetail container() {
        return this.container;
    }

    public final Long startedAt() {
        return this.startedAt;
    }

    public final Long stoppedAt() {
        return this.stoppedAt;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasTaskProperties() {
        return this.taskProperties != null && !(this.taskProperties instanceof SdkAutoConstructList);
    }

    public final List<AttemptEcsTaskDetails> taskProperties() {
        return this.taskProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskProperties() ? this.taskProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptDetail)) {
            return false;
        }
        AttemptDetail other = (AttemptDetail)obj;
        return Objects.equals(this.container(), other.container()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasTaskProperties() == other.hasTaskProperties() && Objects.equals(this.taskProperties(), other.taskProperties());
    }

    public final String toString() {
        return ToString.builder((String)"AttemptDetail").add("Container", (Object)this.container()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("StatusReason", (Object)this.statusReason()).add("TaskProperties", this.hasTaskProperties() ? this.taskProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "taskProperties": {
                return Optional.ofNullable(clazz.cast(this.taskProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttemptDetail, T> g) {
        return obj -> g.apply((AttemptDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AttemptContainerDetail container;
        private Long startedAt;
        private Long stoppedAt;
        private String statusReason;
        private List<AttemptEcsTaskDetails> taskProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptDetail model) {
            this.container(model.container);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.statusReason(model.statusReason);
            this.taskProperties(model.taskProperties);
        }

        public final AttemptContainerDetail.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(AttemptContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(AttemptContainerDetail container) {
            this.container = container;
            return this;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final List<AttemptEcsTaskDetails.Builder> getTaskProperties() {
            List<AttemptEcsTaskDetails.Builder> result = ListAttemptEcsTaskDetailsCopier.copyToBuilder(this.taskProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskProperties(Collection<AttemptEcsTaskDetails.BuilderImpl> taskProperties) {
            this.taskProperties = ListAttemptEcsTaskDetailsCopier.copyFromBuilder(taskProperties);
        }

        @Override
        public final Builder taskProperties(Collection<AttemptEcsTaskDetails> taskProperties) {
            this.taskProperties = ListAttemptEcsTaskDetailsCopier.copy(taskProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(AttemptEcsTaskDetails ... taskProperties) {
            this.taskProperties(Arrays.asList(taskProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskProperties(Consumer<AttemptEcsTaskDetails.Builder> ... taskProperties) {
            this.taskProperties(Stream.of(taskProperties).map(c -> (AttemptEcsTaskDetails)((AttemptEcsTaskDetails.Builder)AttemptEcsTaskDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AttemptDetail build() {
            return new AttemptDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttemptDetail> {
        public Builder container(AttemptContainerDetail var1);

        default public Builder container(Consumer<AttemptContainerDetail.Builder> container) {
            return this.container((AttemptContainerDetail)((AttemptContainerDetail.Builder)AttemptContainerDetail.builder().applyMutation(container)).build());
        }

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder statusReason(String var1);

        public Builder taskProperties(Collection<AttemptEcsTaskDetails> var1);

        public Builder taskProperties(AttemptEcsTaskDetails ... var1);

        public Builder taskProperties(Consumer<AttemptEcsTaskDetails.Builder> ... var1);
    }
}

