/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.JobDefinition;
import software.amazon.awssdk.services.batch.model.JobDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobDefinitionsResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
    private static final SdkField<List<JobDefinition>> JOB_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobDefinitions").getter(DescribeJobDefinitionsResponse.getter(DescribeJobDefinitionsResponse::jobDefinitions)).setter(DescribeJobDefinitionsResponse.setter(Builder::jobDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeJobDefinitionsResponse.getter(DescribeJobDefinitionsResponse::nextToken)).setter(DescribeJobDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobDefinitions", JOB_DEFINITIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<JobDefinition> jobDefinitions;
    private final String nextToken;

    private DescribeJobDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitions = builder.jobDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobDefinitions() {
        return this.jobDefinitions != null && !(this.jobDefinitions instanceof SdkAutoConstructList);
    }

    public final List<JobDefinition> jobDefinitions() {
        return this.jobDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobDefinitions() ? this.jobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsResponse)) {
            return false;
        }
        DescribeJobDefinitionsResponse other = (DescribeJobDefinitionsResponse)((Object)obj);
        return this.hasJobDefinitions() == other.hasJobDefinitions() && Objects.equals(this.jobDefinitions(), other.jobDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeJobDefinitionsResponse").add("JobDefinitions", this.hasJobDefinitions() ? this.jobDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitions": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeJobDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<JobDefinition> jobDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsResponse model) {
            super(model);
            this.jobDefinitions(model.jobDefinitions);
            this.nextToken(model.nextToken);
        }

        public final List<JobDefinition.Builder> getJobDefinitions() {
            List<JobDefinition.Builder> result = JobDefinitionListCopier.copyToBuilder(this.jobDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobDefinitions(Collection<JobDefinition.BuilderImpl> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copyFromBuilder(jobDefinitions);
        }

        @Override
        public final Builder jobDefinitions(Collection<JobDefinition> jobDefinitions) {
            this.jobDefinitions = JobDefinitionListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(JobDefinition ... jobDefinitions) {
            this.jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitions(Consumer<JobDefinition.Builder> ... jobDefinitions) {
            this.jobDefinitions(Stream.of(jobDefinitions).map(c -> (JobDefinition)((JobDefinition.Builder)JobDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeJobDefinitionsResponse build() {
            return new DescribeJobDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobDefinitionsResponse> {
        public Builder jobDefinitions(Collection<JobDefinition> var1);

        public Builder jobDefinitions(JobDefinition ... var1);

        public Builder jobDefinitions(Consumer<JobDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

