/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.BatchAsyncClientBuilder;
import software.amazon.awssdk.services.batch.BatchServiceClientConfiguration;
import software.amazon.awssdk.services.batch.DefaultBatchAsyncClient;
import software.amazon.awssdk.services.batch.DefaultBatchBaseClientBuilder;
import software.amazon.awssdk.services.batch.endpoints.BatchEndpointProvider;

@SdkInternalApi
final class DefaultBatchAsyncClientBuilder
extends DefaultBatchBaseClientBuilder<BatchAsyncClientBuilder, BatchAsyncClient>
implements BatchAsyncClientBuilder {
    DefaultBatchAsyncClientBuilder() {
    }

    @Override
    public DefaultBatchAsyncClientBuilder endpointProvider(BatchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BatchAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBatchAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BatchServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBatchAsyncClient client = new DefaultBatchAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BatchServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BatchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

