/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchAsyncClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest;
import software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse;
import software.amazon.awssdk.services.batch.model.SchedulingPolicyListingDetail;

public class ListSchedulingPoliciesPublisher
implements SdkPublisher<ListSchedulingPoliciesResponse> {
    private final BatchAsyncClient client;
    private final ListSchedulingPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSchedulingPoliciesPublisher(BatchAsyncClient client, ListSchedulingPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSchedulingPoliciesPublisher(BatchAsyncClient client, ListSchedulingPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSchedulingPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSchedulingPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SchedulingPolicyListingDetail> schedulingPolicies() {
        Function<ListSchedulingPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.schedulingPolicies() != null) {
                return response.schedulingPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSchedulingPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSchedulingPoliciesResponseFetcher
    implements AsyncPageFetcher<ListSchedulingPoliciesResponse> {
        private ListSchedulingPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListSchedulingPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSchedulingPoliciesResponse> nextPage(ListSchedulingPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListSchedulingPoliciesPublisher.this.client.listSchedulingPolicies(ListSchedulingPoliciesPublisher.this.firstRequest);
            }
            return ListSchedulingPoliciesPublisher.this.client.listSchedulingPolicies((ListSchedulingPoliciesRequest)((Object)ListSchedulingPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

