/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the compute environment architecture for Batch jobs on Fargate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimePlatform implements SdkPojo, Serializable, ToCopyableBuilder<RuntimePlatform.Builder, RuntimePlatform> {
    private static final SdkField<String> OPERATING_SYSTEM_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operatingSystemFamily").getter(getter(RuntimePlatform::operatingSystemFamily))
            .setter(setter(Builder::operatingSystemFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystemFamily").build())
            .build();

    private static final SdkField<String> CPU_ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpuArchitecture").getter(getter(RuntimePlatform::cpuArchitecture))
            .setter(setter(Builder::cpuArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitecture").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEM_FAMILY_FIELD,
            CPU_ARCHITECTURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operatingSystemFamily;

    private final String cpuArchitecture;

    private RuntimePlatform(BuilderImpl builder) {
        this.operatingSystemFamily = builder.operatingSystemFamily;
        this.cpuArchitecture = builder.cpuArchitecture;
    }

    /**
     * <p>
     * The operating system for the compute environment. Valid values are: <code>LINUX</code> (default),
     * <code>WINDOWS_SERVER_2019_CORE</code>, <code>WINDOWS_SERVER_2019_FULL</code>,
     * <code>WINDOWS_SERVER_2022_CORE</code>, and <code>WINDOWS_SERVER_2022_FULL</code>.
     * </p>
     * <note>
     * <p>
     * The following parameters can’t be set for Windows containers: <code>linuxParameters</code>,
     * <code>privileged</code>, <code>user</code>, <code>ulimits</code>, <code>readonlyRootFilesystem</code>, and
     * <code>efsVolumeConfiguration</code>.
     * </p>
     * </note> <note>
     * <p>
     * The Batch Scheduler checks before registering a task definition with Fargate. If the job requires a Windows
     * container and the first compute environment is <code>LINUX</code>, the compute environment is skipped and the
     * next is checked until a Windows-based compute environment is found.
     * </p>
     * </note> <note>
     * <p>
     * Fargate Spot is not supported for Windows-based containers on Fargate. A job queue will be blocked if a Fargate
     * Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can attach both
     * <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments to the same job queue.
     * </p>
     * </note>
     * 
     * @return The operating system for the compute environment. Valid values are: <code>LINUX</code> (default),
     *         <code>WINDOWS_SERVER_2019_CORE</code>, <code>WINDOWS_SERVER_2019_FULL</code>,
     *         <code>WINDOWS_SERVER_2022_CORE</code>, and <code>WINDOWS_SERVER_2022_FULL</code>.</p> <note>
     *         <p>
     *         The following parameters can’t be set for Windows containers: <code>linuxParameters</code>,
     *         <code>privileged</code>, <code>user</code>, <code>ulimits</code>, <code>readonlyRootFilesystem</code>,
     *         and <code>efsVolumeConfiguration</code>.
     *         </p>
     *         </note> <note>
     *         <p>
     *         The Batch Scheduler checks before registering a task definition with Fargate. If the job requires a
     *         Windows container and the first compute environment is <code>LINUX</code>, the compute environment is
     *         skipped and the next is checked until a Windows-based compute environment is found.
     *         </p>
     *         </note> <note>
     *         <p>
     *         Fargate Spot is not supported for Windows-based containers on Fargate. A job queue will be blocked if a
     *         Fargate Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you
     *         can attach both <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments to the same job
     *         queue.
     *         </p>
     */
    public final String operatingSystemFamily() {
        return operatingSystemFamily;
    }

    /**
     * <p>
     * The vCPU architecture. The default value is <code>X86_64</code>. Valid values are <code>X86_64</code> and
     * <code> ARM64</code>.
     * </p>
     * <note>
     * <p>
     * This parameter must be set to <code>X86_64</code> for Windows containers.
     * </p>
     * </note>
     * 
     * @return The vCPU architecture. The default value is <code>X86_64</code>. Valid values are <code>X86_64</code> and
     *         <code> ARM64</code>.</p> <note>
     *         <p>
     *         This parameter must be set to <code>X86_64</code> for Windows containers.
     *         </p>
     */
    public final String cpuArchitecture() {
        return cpuArchitecture;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemFamily());
        hashCode = 31 * hashCode + Objects.hashCode(cpuArchitecture());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimePlatform)) {
            return false;
        }
        RuntimePlatform other = (RuntimePlatform) obj;
        return Objects.equals(operatingSystemFamily(), other.operatingSystemFamily())
                && Objects.equals(cpuArchitecture(), other.cpuArchitecture());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimePlatform").add("OperatingSystemFamily", operatingSystemFamily())
                .add("CpuArchitecture", cpuArchitecture()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operatingSystemFamily":
            return Optional.ofNullable(clazz.cast(operatingSystemFamily()));
        case "cpuArchitecture":
            return Optional.ofNullable(clazz.cast(cpuArchitecture()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimePlatform, T> g) {
        return obj -> g.apply((RuntimePlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimePlatform> {
        /**
         * <p>
         * The operating system for the compute environment. Valid values are: <code>LINUX</code> (default),
         * <code>WINDOWS_SERVER_2019_CORE</code>, <code>WINDOWS_SERVER_2019_FULL</code>,
         * <code>WINDOWS_SERVER_2022_CORE</code>, and <code>WINDOWS_SERVER_2022_FULL</code>.
         * </p>
         * <note>
         * <p>
         * The following parameters can’t be set for Windows containers: <code>linuxParameters</code>,
         * <code>privileged</code>, <code>user</code>, <code>ulimits</code>, <code>readonlyRootFilesystem</code>, and
         * <code>efsVolumeConfiguration</code>.
         * </p>
         * </note> <note>
         * <p>
         * The Batch Scheduler checks before registering a task definition with Fargate. If the job requires a Windows
         * container and the first compute environment is <code>LINUX</code>, the compute environment is skipped and the
         * next is checked until a Windows-based compute environment is found.
         * </p>
         * </note> <note>
         * <p>
         * Fargate Spot is not supported for Windows-based containers on Fargate. A job queue will be blocked if a
         * Fargate Windows job is submitted to a job queue with only Fargate Spot compute environments. However, you can
         * attach both <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments to the same job queue.
         * </p>
         * </note>
         * 
         * @param operatingSystemFamily
         *        The operating system for the compute environment. Valid values are: <code>LINUX</code> (default),
         *        <code>WINDOWS_SERVER_2019_CORE</code>, <code>WINDOWS_SERVER_2019_FULL</code>,
         *        <code>WINDOWS_SERVER_2022_CORE</code>, and <code>WINDOWS_SERVER_2022_FULL</code>.</p> <note>
         *        <p>
         *        The following parameters can’t be set for Windows containers: <code>linuxParameters</code>,
         *        <code>privileged</code>, <code>user</code>, <code>ulimits</code>, <code>readonlyRootFilesystem</code>,
         *        and <code>efsVolumeConfiguration</code>.
         *        </p>
         *        </note> <note>
         *        <p>
         *        The Batch Scheduler checks before registering a task definition with Fargate. If the job requires a
         *        Windows container and the first compute environment is <code>LINUX</code>, the compute environment is
         *        skipped and the next is checked until a Windows-based compute environment is found.
         *        </p>
         *        </note> <note>
         *        <p>
         *        Fargate Spot is not supported for Windows-based containers on Fargate. A job queue will be blocked if
         *        a Fargate Windows job is submitted to a job queue with only Fargate Spot compute environments.
         *        However, you can attach both <code>FARGATE</code> and <code>FARGATE_SPOT</code> compute environments
         *        to the same job queue.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemFamily(String operatingSystemFamily);

        /**
         * <p>
         * The vCPU architecture. The default value is <code>X86_64</code>. Valid values are <code>X86_64</code> and
         * <code> ARM64</code>.
         * </p>
         * <note>
         * <p>
         * This parameter must be set to <code>X86_64</code> for Windows containers.
         * </p>
         * </note>
         * 
         * @param cpuArchitecture
         *        The vCPU architecture. The default value is <code>X86_64</code>. Valid values are <code>X86_64</code>
         *        and <code> ARM64</code>.</p> <note>
         *        <p>
         *        This parameter must be set to <code>X86_64</code> for Windows containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuArchitecture(String cpuArchitecture);
    }

    static final class BuilderImpl implements Builder {
        private String operatingSystemFamily;

        private String cpuArchitecture;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimePlatform model) {
            operatingSystemFamily(model.operatingSystemFamily);
            cpuArchitecture(model.cpuArchitecture);
        }

        public final String getOperatingSystemFamily() {
            return operatingSystemFamily;
        }

        public final void setOperatingSystemFamily(String operatingSystemFamily) {
            this.operatingSystemFamily = operatingSystemFamily;
        }

        @Override
        public final Builder operatingSystemFamily(String operatingSystemFamily) {
            this.operatingSystemFamily = operatingSystemFamily;
            return this;
        }

        public final String getCpuArchitecture() {
            return cpuArchitecture;
        }

        public final void setCpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
        }

        @Override
        public final Builder cpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            return this;
        }

        @Override
        public RuntimePlatform build() {
            return new RuntimePlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
