/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CRUpdateAllocationStrategy {
    BEST_FIT_PROGRESSIVE("BEST_FIT_PROGRESSIVE"),
    SPOT_CAPACITY_OPTIMIZED("SPOT_CAPACITY_OPTIMIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CRUpdateAllocationStrategy> VALUE_MAP;
    private final String value;

    private CRUpdateAllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CRUpdateAllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CRUpdateAllocationStrategy> knownValues() {
        EnumSet<CRUpdateAllocationStrategy> knownValues = EnumSet.allOf(CRUpdateAllocationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CRUpdateAllocationStrategy.class, CRUpdateAllocationStrategy::toString);
    }
}

