/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterJobDefinitionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, RegisterJobDefinitionResponse> {
    private final String jobDefinitionName;
    private final String jobDefinitionArn;
    private final Integer revision;

    private RegisterJobDefinitionResponse(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public Integer revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionResponse)) {
            return false;
        }
        RegisterJobDefinitionResponse other = (RegisterJobDefinitionResponse)((Object)obj);
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(this.revision(), other.revision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(this.jobDefinitionName()).append(",");
        }
        if (this.jobDefinitionArn() != null) {
            sb.append("JobDefinitionArn: ").append(this.jobDefinitionArn()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitionName": {
                return Optional.of(clazz.cast(this.jobDefinitionName()));
            }
            case "jobDefinitionArn": {
                return Optional.of(clazz.cast(this.jobDefinitionArn()));
            }
            case "revision": {
                return Optional.of(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String jobDefinitionArn;
        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionResponse model) {
            this.jobDefinitionName(model.jobDefinitionName);
            this.jobDefinitionArn(model.jobDefinitionArn);
            this.revision(model.revision);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        public RegisterJobDefinitionResponse build() {
            return new RegisterJobDefinitionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterJobDefinitionResponse> {
        public Builder jobDefinitionName(String var1);

        public Builder jobDefinitionArn(String var1);

        public Builder revision(Integer var1);
    }
}

