/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.CEStatus;
import software.amazon.awssdk.services.batch.model.CEType;
import software.amazon.awssdk.services.batch.model.ComputeResource;
import software.amazon.awssdk.services.batch.transform.ComputeEnvironmentDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComputeEnvironmentDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ComputeEnvironmentDetail> {
    private final String computeEnvironmentName;
    private final String computeEnvironmentArn;
    private final String ecsClusterArn;
    private final String type;
    private final String state;
    private final String status;
    private final String statusReason;
    private final ComputeResource computeResources;
    private final String serviceRole;

    private ComputeEnvironmentDetail(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.type = builder.type;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    public String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public String computeEnvironmentArn() {
        return this.computeEnvironmentArn;
    }

    public String ecsClusterArn() {
        return this.ecsClusterArn;
    }

    public CEType type() {
        return CEType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public CEState state() {
        return CEState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public CEStatus status() {
        return CEStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public ComputeResource computeResources() {
        return this.computeResources;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.computeEnvironmentName() == null ? 0 : this.computeEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.computeEnvironmentArn() == null ? 0 : this.computeEnvironmentArn().hashCode());
        hashCode = 31 * hashCode + (this.ecsClusterArn() == null ? 0 : this.ecsClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.computeResources() == null ? 0 : this.computeResources().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentDetail)) {
            return false;
        }
        ComputeEnvironmentDetail other = (ComputeEnvironmentDetail)obj;
        if (other.computeEnvironmentName() == null ^ this.computeEnvironmentName() == null) {
            return false;
        }
        if (other.computeEnvironmentName() != null && !other.computeEnvironmentName().equals(this.computeEnvironmentName())) {
            return false;
        }
        if (other.computeEnvironmentArn() == null ^ this.computeEnvironmentArn() == null) {
            return false;
        }
        if (other.computeEnvironmentArn() != null && !other.computeEnvironmentArn().equals(this.computeEnvironmentArn())) {
            return false;
        }
        if (other.ecsClusterArn() == null ^ this.ecsClusterArn() == null) {
            return false;
        }
        if (other.ecsClusterArn() != null && !other.ecsClusterArn().equals(this.ecsClusterArn())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.computeResources() == null ^ this.computeResources() == null) {
            return false;
        }
        if (other.computeResources() != null && !other.computeResources().equals(this.computeResources())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        return other.serviceRole() == null || other.serviceRole().equals(this.serviceRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.computeEnvironmentName() != null) {
            sb.append("ComputeEnvironmentName: ").append(this.computeEnvironmentName()).append(",");
        }
        if (this.computeEnvironmentArn() != null) {
            sb.append("ComputeEnvironmentArn: ").append(this.computeEnvironmentArn()).append(",");
        }
        if (this.ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(this.ecsClusterArn()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.computeResources() != null) {
            sb.append("ComputeResources: ").append(this.computeResources()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironmentName": {
                return Optional.of(clazz.cast(this.computeEnvironmentName()));
            }
            case "computeEnvironmentArn": {
                return Optional.of(clazz.cast(this.computeEnvironmentArn()));
            }
            case "ecsClusterArn": {
                return Optional.of(clazz.cast(this.ecsClusterArn()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "statusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "computeResources": {
                return Optional.of(clazz.cast(this.computeResources()));
            }
            case "serviceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeEnvironmentDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String computeEnvironmentArn;
        private String ecsClusterArn;
        private String type;
        private String state;
        private String status;
        private String statusReason;
        private ComputeResource computeResources;
        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentDetail model) {
            this.computeEnvironmentName(model.computeEnvironmentName);
            this.computeEnvironmentArn(model.computeEnvironmentArn);
            this.ecsClusterArn(model.ecsClusterArn);
            this.type(model.type);
            this.state(model.state);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.computeResources(model.computeResources);
            this.serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getComputeEnvironmentArn() {
            return this.computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        public final String getEcsClusterArn() {
            return this.ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CEStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final ComputeResource.Builder getComputeResources() {
            return this.computeResources != null ? this.computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public ComputeEnvironmentDetail build() {
            return new ComputeEnvironmentDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComputeEnvironmentDetail> {
        public Builder computeEnvironmentName(String var1);

        public Builder computeEnvironmentArn(String var1);

        public Builder ecsClusterArn(String var1);

        public Builder type(String var1);

        public Builder type(CEType var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder status(String var1);

        public Builder status(CEStatus var1);

        public Builder statusReason(String var1);

        public Builder computeResources(ComputeResource var1);

        public Builder serviceRole(String var1);
    }
}

