/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.JobDetail;

@SdkInternalApi
public class JobDetailMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobName").build();
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").build();
    private static final MarshallingInfo<String> JOBQUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobQueue").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<List> ATTEMPTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attempts").build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusReason").build();
    private static final MarshallingInfo<Long> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<StructuredPojo> RETRYSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryStrategy").build();
    private static final MarshallingInfo<Long> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").build();
    private static final MarshallingInfo<Long> STOPPEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stoppedAt").build();
    private static final MarshallingInfo<List> DEPENDSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dependsOn").build();
    private static final MarshallingInfo<String> JOBDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinition").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final MarshallingInfo<StructuredPojo> CONTAINER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("container").build();
    private static final JobDetailMarshaller INSTANCE = new JobDetailMarshaller();

    public static JobDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobDetail jobDetail, ProtocolMarshaller protocolMarshaller) {
        if (jobDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobDetail.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.jobQueue(), JOBQUEUE_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.status(), STATUS_BINDING);
            protocolMarshaller.marshall(jobDetail.attempts(), ATTEMPTS_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.statusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.retryStrategy(), RETRYSTRATEGY_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.stoppedAt(), STOPPEDAT_BINDING);
            protocolMarshaller.marshall(jobDetail.dependsOn(), DEPENDSON_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.jobDefinition(), JOBDEFINITION_BINDING);
            protocolMarshaller.marshall(jobDetail.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)jobDetail.container(), CONTAINER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

