/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComputeEnvironmentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
    private final List<ComputeEnvironmentDetail> computeEnvironments;
    private final String nextToken;

    private DescribeComputeEnvironmentsResponse(BuilderImpl builder) {
        this.computeEnvironments = builder.computeEnvironments;
        this.nextToken = builder.nextToken;
    }

    public List<ComputeEnvironmentDetail> computeEnvironments() {
        return this.computeEnvironments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.computeEnvironments() == null ? 0 : this.computeEnvironments().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsResponse)) {
            return false;
        }
        DescribeComputeEnvironmentsResponse other = (DescribeComputeEnvironmentsResponse)((Object)obj);
        if (other.computeEnvironments() == null ^ this.computeEnvironments() == null) {
            return false;
        }
        if (other.computeEnvironments() != null && !other.computeEnvironments().equals(this.computeEnvironments())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeEnvironments() != null) {
            sb.append("ComputeEnvironments: ").append(this.computeEnvironments()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ComputeEnvironmentDetail> computeEnvironments;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsResponse model) {
            this.setComputeEnvironments(model.computeEnvironments);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ComputeEnvironmentDetail> getComputeEnvironments() {
            return this.computeEnvironments;
        }

        @Override
        public final Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(ComputeEnvironmentDetail ... computeEnvironments) {
            this.computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        public final void setComputeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeComputeEnvironmentsResponse build() {
            return new DescribeComputeEnvironmentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
        public Builder computeEnvironments(Collection<ComputeEnvironmentDetail> var1);

        public Builder computeEnvironments(ComputeEnvironmentDetail ... var1);

        public Builder nextToken(String var1);
    }
}

