/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeComputeEnvironmentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeComputeEnvironmentsRequest> {
    private final List<String> computeEnvironments;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeComputeEnvironmentsRequest(BuilderImpl builder) {
        this.computeEnvironments = builder.computeEnvironments;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> computeEnvironments() {
        return this.computeEnvironments;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.computeEnvironments() == null ? 0 : this.computeEnvironments().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsRequest)) {
            return false;
        }
        DescribeComputeEnvironmentsRequest other = (DescribeComputeEnvironmentsRequest)((Object)obj);
        if (other.computeEnvironments() == null ^ this.computeEnvironments() == null) {
            return false;
        }
        if (other.computeEnvironments() != null && !other.computeEnvironments().equals(this.computeEnvironments())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeEnvironments() != null) {
            sb.append("ComputeEnvironments: ").append(this.computeEnvironments()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> computeEnvironments;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsRequest model) {
            this.setComputeEnvironments(model.computeEnvironments);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getComputeEnvironments() {
            return this.computeEnvironments;
        }

        @Override
        public final Builder computeEnvironments(Collection<String> computeEnvironments) {
            this.computeEnvironments = StringListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(String ... computeEnvironments) {
            this.computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        public final void setComputeEnvironments(Collection<String> computeEnvironments) {
            this.computeEnvironments = StringListCopier.copy(computeEnvironments);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeComputeEnvironmentsRequest build() {
            return new DescribeComputeEnvironmentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeComputeEnvironmentsRequest> {
        public Builder computeEnvironments(Collection<String> var1);

        public Builder computeEnvironments(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

