/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.MountPoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MountPointMarshaller {
    private static final MarshallingInfo<String> CONTAINERPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerPath").isBinary(false).build();
    private static final MarshallingInfo<Boolean> READONLY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readOnly").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEVOLUME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVolume").isBinary(false).build();
    private static final MountPointMarshaller INSTANCE = new MountPointMarshaller();

    private MountPointMarshaller() {
    }

    public static MountPointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MountPoint mountPoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mountPoint, (String)"mountPoint");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mountPoint.containerPath(), CONTAINERPATH_BINDING);
            protocolMarshaller.marshall((Object)mountPoint.readOnly(), READONLY_BINDING);
            protocolMarshaller.marshall((Object)mountPoint.sourceVolume(), SOURCEVOLUME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

