/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.JobSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobSummaryMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobName").isBinary(false).build();
    private static final MarshallingInfo<Long> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusReason").isBinary(false).build();
    private static final MarshallingInfo<Long> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").isBinary(false).build();
    private static final MarshallingInfo<Long> STOPPEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stoppedAt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONTAINER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("container").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ARRAYPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arrayProperties").isBinary(false).build();
    private static final JobSummaryMarshaller INSTANCE = new JobSummaryMarshaller();

    private JobSummaryMarshaller() {
    }

    public static JobSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobSummary jobSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobSummary, (String)"jobSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobSummary.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.statusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.startedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.stoppedAt(), STOPPEDAT_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.container(), CONTAINER_BINDING);
            protocolMarshaller.marshall((Object)jobSummary.arrayProperties(), ARRAYPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

