/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary;
import software.amazon.awssdk.services.batch.model.ContainerSummary;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.services.batch.transform.JobSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, JobSummary> {
    private final String jobId;
    private final String jobName;
    private final Long createdAt;
    private final String status;
    private final String statusReason;
    private final Long startedAt;
    private final Long stoppedAt;
    private final ContainerSummary container;
    private final ArrayPropertiesSummary arrayProperties;

    private JobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.container = builder.container;
        this.arrayProperties = builder.arrayProperties;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobName() {
        return this.jobName;
    }

    public Long createdAt() {
        return this.createdAt;
    }

    public JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Long startedAt() {
        return this.startedAt;
    }

    public Long stoppedAt() {
        return this.stoppedAt;
    }

    public ContainerSummary container() {
        return this.container;
    }

    public ArrayPropertiesSummary arrayProperties() {
        return this.arrayProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.arrayProperties(), other.arrayProperties());
    }

    public String toString() {
        return ToString.builder((String)"JobSummary").add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("Container", (Object)this.container()).add("ArrayProperties", (Object)this.arrayProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "arrayProperties": {
                return Optional.ofNullable(clazz.cast(this.arrayProperties()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobName;
        private Long createdAt;
        private String status;
        private String statusReason;
        private Long startedAt;
        private Long stoppedAt;
        private ContainerSummary container;
        private ArrayPropertiesSummary arrayProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.container(model.container);
            this.arrayProperties(model.arrayProperties);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final ContainerSummary.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerSummary container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerSummary.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final ArrayPropertiesSummary.Builder getArrayProperties() {
            return this.arrayProperties != null ? this.arrayProperties.toBuilder() : null;
        }

        @Override
        public final Builder arrayProperties(ArrayPropertiesSummary arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final void setArrayProperties(ArrayPropertiesSummary.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        public JobSummary build() {
            return new JobSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobSummary> {
        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder createdAt(Long var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder statusReason(String var1);

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder container(ContainerSummary var1);

        default public Builder container(Consumer<ContainerSummary.Builder> container) {
            return this.container((ContainerSummary)((ContainerSummary.Builder)ContainerSummary.builder().applyMutation(container)).build());
        }

        public Builder arrayProperties(ArrayPropertiesSummary var1);

        default public Builder arrayProperties(Consumer<ArrayPropertiesSummary.Builder> arrayProperties) {
            return this.arrayProperties((ArrayPropertiesSummary)((ArrayPropertiesSummary.Builder)ArrayPropertiesSummary.builder().applyMutation(arrayProperties)).build());
        }
    }
}

