/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.Ulimit;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UlimitMarshaller {
    private static final MarshallingInfo<Integer> HARDLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hardLimit").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Integer> SOFTLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softLimit").isBinary(false).build();
    private static final UlimitMarshaller INSTANCE = new UlimitMarshaller();

    private UlimitMarshaller() {
    }

    public static UlimitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Ulimit ulimit, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ulimit, (String)"ulimit");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ulimit.hardLimit(), HARDLIMIT_BINDING);
            protocolMarshaller.marshall((Object)ulimit.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)ulimit.softLimit(), SOFTLIMIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

