/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.JobDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobDefinitionMarshaller {
    private static final MarshallingInfo<String> JOBDEFINITIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinitionName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBDEFINITIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinitionArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RETRYSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryStrategy").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONTAINERPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerProperties").isBinary(false).build();
    private static final JobDefinitionMarshaller INSTANCE = new JobDefinitionMarshaller();

    private JobDefinitionMarshaller() {
    }

    public static JobDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobDefinition jobDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobDefinition, (String)"jobDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobDefinition.jobDefinitionName(), JOBDEFINITIONNAME_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.jobDefinitionArn(), JOBDEFINITIONARN_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.revision(), REVISION_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.type(), TYPE_BINDING);
            protocolMarshaller.marshall(jobDefinition.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.retryStrategy(), RETRYSTRATEGY_BINDING);
            protocolMarshaller.marshall((Object)jobDefinition.containerProperties(), CONTAINERPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

