/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ComputeResourceUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComputeResourceUpdateMarshaller {
    private static final MarshallingInfo<Integer> MINVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minvCpus").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxvCpus").isBinary(false).build();
    private static final MarshallingInfo<Integer> DESIREDVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredvCpus").isBinary(false).build();
    private static final ComputeResourceUpdateMarshaller INSTANCE = new ComputeResourceUpdateMarshaller();

    private ComputeResourceUpdateMarshaller() {
    }

    public static ComputeResourceUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComputeResourceUpdate computeResourceUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)computeResourceUpdate, (String)"computeResourceUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)computeResourceUpdate.minvCpus(), MINVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResourceUpdate.maxvCpus(), MAXVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResourceUpdate.desiredvCpus(), DESIREDVCPUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

