/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterJobDefinitionResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, RegisterJobDefinitionResponse> {
    private final String jobDefinitionName;
    private final String jobDefinitionArn;
    private final Integer revision;

    private RegisterJobDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public Integer revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionResponse)) {
            return false;
        }
        RegisterJobDefinitionResponse other = (RegisterJobDefinitionResponse)((Object)obj);
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(this.revision(), other.revision());
    }

    public String toString() {
        return ToString.builder((String)"RegisterJobDefinitionResponse").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("JobDefinitionArn", (Object)this.jobDefinitionArn()).add("Revision", (Object)this.revision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "jobDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionArn()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String jobDefinitionArn;
        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionResponse model) {
            super(model);
            this.jobDefinitionName(model.jobDefinitionName);
            this.jobDefinitionArn(model.jobDefinitionArn);
            this.revision(model.revision);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public RegisterJobDefinitionResponse build() {
            return new RegisterJobDefinitionResponse(this);
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    CopyableBuilder<Builder, RegisterJobDefinitionResponse> {
        public Builder jobDefinitionName(String var1);

        public Builder jobDefinitionArn(String var1);

        public Builder revision(Integer var1);
    }
}

