/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.AttemptDetail;
import software.amazon.awssdk.services.batch.model.AttemptDetailsCopier;
import software.amazon.awssdk.services.batch.model.ContainerDetail;
import software.amazon.awssdk.services.batch.model.JobDependency;
import software.amazon.awssdk.services.batch.model.JobDependencyListCopier;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.transform.JobDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, JobDetail> {
    private final String jobName;
    private final String jobId;
    private final String jobQueue;
    private final String status;
    private final List<AttemptDetail> attempts;
    private final String statusReason;
    private final Long createdAt;
    private final RetryStrategy retryStrategy;
    private final Long startedAt;
    private final Long stoppedAt;
    private final List<JobDependency> dependsOn;
    private final String jobDefinition;
    private final Map<String, String> parameters;
    private final ContainerDetail container;

    private JobDetail(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
        this.jobQueue = builder.jobQueue;
        this.status = builder.status;
        this.attempts = builder.attempts;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.retryStrategy = builder.retryStrategy;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.container = builder.container;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<AttemptDetail> attempts() {
        return this.attempts;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Long createdAt() {
        return this.createdAt;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public Long startedAt() {
        return this.startedAt;
    }

    public Long stoppedAt() {
        return this.stoppedAt;
    }

    public List<JobDependency> dependsOn() {
        return this.dependsOn;
    }

    public String jobDefinition() {
        return this.jobDefinition;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public ContainerDetail container() {
        return this.container;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetail)) {
            return false;
        }
        JobDetail other = (JobDetail)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobQueue(), other.jobQueue()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.attempts(), other.attempts()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.dependsOn(), other.dependsOn()) && Objects.equals(this.jobDefinition(), other.jobDefinition()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.container(), other.container());
    }

    public String toString() {
        return ToString.builder((String)"JobDetail").add("JobName", (Object)this.jobName()).add("JobId", (Object)this.jobId()).add("JobQueue", (Object)this.jobQueue()).add("Status", (Object)this.statusAsString()).add("Attempts", this.attempts()).add("StatusReason", (Object)this.statusReason()).add("CreatedAt", (Object)this.createdAt()).add("RetryStrategy", (Object)this.retryStrategy()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("DependsOn", this.dependsOn()).add("JobDefinition", (Object)this.jobDefinition()).add("Parameters", this.parameters()).add("Container", (Object)this.container()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
            case "jobQueue": {
                return Optional.of(clazz.cast(this.jobQueue()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "attempts": {
                return Optional.of(clazz.cast(this.attempts()));
            }
            case "statusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "createdAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "retryStrategy": {
                return Optional.of(clazz.cast(this.retryStrategy()));
            }
            case "startedAt": {
                return Optional.of(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.of(clazz.cast(this.stoppedAt()));
            }
            case "dependsOn": {
                return Optional.of(clazz.cast(this.dependsOn()));
            }
            case "jobDefinition": {
                return Optional.of(clazz.cast(this.jobDefinition()));
            }
            case "parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "container": {
                return Optional.of(clazz.cast(this.container()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobId;
        private String jobQueue;
        private String status;
        private List<AttemptDetail> attempts;
        private String statusReason;
        private Long createdAt;
        private RetryStrategy retryStrategy;
        private Long startedAt;
        private Long stoppedAt;
        private List<JobDependency> dependsOn;
        private String jobDefinition;
        private Map<String, String> parameters;
        private ContainerDetail container;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetail model) {
            this.jobName(model.jobName);
            this.jobId(model.jobId);
            this.jobQueue(model.jobQueue);
            this.status(model.status);
            this.attempts(model.attempts);
            this.statusReason(model.statusReason);
            this.createdAt(model.createdAt);
            this.retryStrategy(model.retryStrategy);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.dependsOn(model.dependsOn);
            this.jobDefinition(model.jobDefinition);
            this.parameters(model.parameters);
            this.container(model.container);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<AttemptDetail.Builder> getAttempts() {
            return this.attempts != null ? (Collection)this.attempts.stream().map(AttemptDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attempts(Collection<AttemptDetail> attempts) {
            this.attempts = AttemptDetailsCopier.copy(attempts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(AttemptDetail ... attempts) {
            this.attempts(Arrays.asList(attempts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attempts(Consumer<AttemptDetail.Builder> ... attempts) {
            this.attempts(Stream.of(attempts).map(c -> (AttemptDetail)((AttemptDetail.Builder)AttemptDetail.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttempts(Collection<AttemptDetail.BuilderImpl> attempts) {
            this.attempts = AttemptDetailsCopier.copyFromBuilder(attempts);
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final Collection<JobDependency.Builder> getDependsOn() {
            return this.dependsOn != null ? (Collection)this.dependsOn.stream().map(JobDependency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (JobDependency)((JobDependency.Builder)JobDependency.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerDetail.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public JobDetail build() {
            return new JobDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobDetail> {
        public Builder jobName(String var1);

        public Builder jobId(String var1);

        public Builder jobQueue(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder attempts(Collection<AttemptDetail> var1);

        public Builder attempts(AttemptDetail ... var1);

        public Builder attempts(Consumer<AttemptDetail.Builder> ... var1);

        public Builder statusReason(String var1);

        public Builder createdAt(Long var1);

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().apply(retryStrategy)).build());
        }

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder dependsOn(Collection<JobDependency> var1);

        public Builder dependsOn(JobDependency ... var1);

        public Builder dependsOn(Consumer<JobDependency.Builder> ... var1);

        public Builder jobDefinition(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder container(ContainerDetail var1);

        default public Builder container(Consumer<ContainerDetail.Builder> container) {
            return this.container((ContainerDetail)((ContainerDetail.Builder)ContainerDetail.builder().apply(container)).build());
        }
    }
}

