/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateComputeEnvironmentResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, CreateComputeEnvironmentResponse> {
    private final String computeEnvironmentName;
    private final String computeEnvironmentArn;

    private CreateComputeEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
    }

    public String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public String computeEnvironmentArn() {
        return this.computeEnvironmentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeEnvironmentResponse)) {
            return false;
        }
        CreateComputeEnvironmentResponse other = (CreateComputeEnvironmentResponse)((Object)obj);
        return Objects.equals(this.computeEnvironmentName(), other.computeEnvironmentName()) && Objects.equals(this.computeEnvironmentArn(), other.computeEnvironmentArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateComputeEnvironmentResponse").add("ComputeEnvironmentName", (Object)this.computeEnvironmentName()).add("ComputeEnvironmentArn", (Object)this.computeEnvironmentArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironmentName": {
                return Optional.of(clazz.cast(this.computeEnvironmentName()));
            }
            case "computeEnvironmentArn": {
                return Optional.of(clazz.cast(this.computeEnvironmentArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String computeEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeEnvironmentResponse model) {
            super(model);
            this.computeEnvironmentName(model.computeEnvironmentName);
            this.computeEnvironmentArn(model.computeEnvironmentArn);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getComputeEnvironmentArn() {
            return this.computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        @Override
        public CreateComputeEnvironmentResponse build() {
            return new CreateComputeEnvironmentResponse(this);
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    CopyableBuilder<Builder, CreateComputeEnvironmentResponse> {
        public Builder computeEnvironmentName(String var1);

        public Builder computeEnvironmentArn(String var1);
    }
}

