/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupstorage.BackupStorageClient;
import software.amazon.awssdk.services.backupstorage.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse;

public class ListObjectsIterable
implements SdkIterable<ListObjectsResponse> {
    private final BackupStorageClient client;
    private final ListObjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectsIterable(BackupStorageClient client, ListObjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListObjectsResponseFetcher();
    }

    public Iterator<ListObjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListObjectsResponseFetcher
    implements SyncPageFetcher<ListObjectsResponse> {
        private ListObjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObjectsResponse nextPage(ListObjectsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectsIterable.this.client.listObjects(ListObjectsIterable.this.firstRequest);
            }
            return ListObjectsIterable.this.client.listObjects((ListObjectsRequest)((Object)ListObjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

