/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClientBuilder;
import software.amazon.awssdk.services.backupstorage.BackupStorageServiceClientConfiguration;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageAsyncClientBuilder;
import software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.DeleteObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.GetChunkRequest;
import software.amazon.awssdk.services.backupstorage.model.GetChunkResponse;
import software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest;
import software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse;
import software.amazon.awssdk.services.backupstorage.model.ListChunksRequest;
import software.amazon.awssdk.services.backupstorage.model.ListChunksResponse;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse;
import software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest;
import software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse;
import software.amazon.awssdk.services.backupstorage.model.PutChunkRequest;
import software.amazon.awssdk.services.backupstorage.model.PutChunkResponse;
import software.amazon.awssdk.services.backupstorage.model.PutObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.PutObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.StartObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.StartObjectResponse;
import software.amazon.awssdk.services.backupstorage.paginators.ListChunksPublisher;
import software.amazon.awssdk.services.backupstorage.paginators.ListObjectsPublisher;

@SdkPublicApi
@ThreadSafe
public interface BackupStorageAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "backup-storage";
    public static final String SERVICE_METADATA_ID = "backupstorage";

    default public CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteObjectResponse> deleteObject(Consumer<DeleteObjectRequest.Builder> deleteObjectRequest) {
        return this.deleteObject((DeleteObjectRequest)((Object)((DeleteObjectRequest.Builder)DeleteObjectRequest.builder().applyMutation(deleteObjectRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> getChunk(GetChunkRequest getChunkRequest, AsyncResponseTransformer<GetChunkResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getChunk(Consumer<GetChunkRequest.Builder> getChunkRequest, AsyncResponseTransformer<GetChunkResponse, ReturnT> asyncResponseTransformer) {
        return this.getChunk((GetChunkRequest)((Object)((GetChunkRequest.Builder)GetChunkRequest.builder().applyMutation(getChunkRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetChunkResponse> getChunk(GetChunkRequest getChunkRequest, Path destinationPath) {
        return this.getChunk(getChunkRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetChunkResponse> getChunk(Consumer<GetChunkRequest.Builder> getChunkRequest, Path destinationPath) {
        return this.getChunk((GetChunkRequest)((Object)((GetChunkRequest.Builder)GetChunkRequest.builder().applyMutation(getChunkRequest)).build()), destinationPath);
    }

    default public <ReturnT> CompletableFuture<ReturnT> getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest, AsyncResponseTransformer<GetObjectMetadataResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getObjectMetadata(Consumer<GetObjectMetadataRequest.Builder> getObjectMetadataRequest, AsyncResponseTransformer<GetObjectMetadataResponse, ReturnT> asyncResponseTransformer) {
        return this.getObjectMetadata((GetObjectMetadataRequest)((Object)((GetObjectMetadataRequest.Builder)GetObjectMetadataRequest.builder().applyMutation(getObjectMetadataRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetObjectMetadataResponse> getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest, Path destinationPath) {
        return this.getObjectMetadata(getObjectMetadataRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetObjectMetadataResponse> getObjectMetadata(Consumer<GetObjectMetadataRequest.Builder> getObjectMetadataRequest, Path destinationPath) {
        return this.getObjectMetadata((GetObjectMetadataRequest)((Object)((GetObjectMetadataRequest.Builder)GetObjectMetadataRequest.builder().applyMutation(getObjectMetadataRequest)).build()), destinationPath);
    }

    default public CompletableFuture<ListChunksResponse> listChunks(ListChunksRequest listChunksRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListChunksResponse> listChunks(Consumer<ListChunksRequest.Builder> listChunksRequest) {
        return this.listChunks((ListChunksRequest)((Object)((ListChunksRequest.Builder)ListChunksRequest.builder().applyMutation(listChunksRequest)).build()));
    }

    default public ListChunksPublisher listChunksPaginator(ListChunksRequest listChunksRequest) {
        return new ListChunksPublisher(this, listChunksRequest);
    }

    default public ListChunksPublisher listChunksPaginator(Consumer<ListChunksRequest.Builder> listChunksRequest) {
        return this.listChunksPaginator((ListChunksRequest)((Object)((ListChunksRequest.Builder)ListChunksRequest.builder().applyMutation(listChunksRequest)).build()));
    }

    default public CompletableFuture<ListObjectsResponse> listObjects(ListObjectsRequest listObjectsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListObjectsResponse> listObjects(Consumer<ListObjectsRequest.Builder> listObjectsRequest) {
        return this.listObjects((ListObjectsRequest)((Object)((ListObjectsRequest.Builder)ListObjectsRequest.builder().applyMutation(listObjectsRequest)).build()));
    }

    default public ListObjectsPublisher listObjectsPaginator(ListObjectsRequest listObjectsRequest) {
        return new ListObjectsPublisher(this, listObjectsRequest);
    }

    default public ListObjectsPublisher listObjectsPaginator(Consumer<ListObjectsRequest.Builder> listObjectsRequest) {
        return this.listObjectsPaginator((ListObjectsRequest)((Object)((ListObjectsRequest.Builder)ListObjectsRequest.builder().applyMutation(listObjectsRequest)).build()));
    }

    default public CompletableFuture<NotifyObjectCompleteResponse> notifyObjectComplete(NotifyObjectCompleteRequest notifyObjectCompleteRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<NotifyObjectCompleteResponse> notifyObjectComplete(Consumer<NotifyObjectCompleteRequest.Builder> notifyObjectCompleteRequest, AsyncRequestBody requestBody) {
        return this.notifyObjectComplete((NotifyObjectCompleteRequest)((Object)((NotifyObjectCompleteRequest.Builder)NotifyObjectCompleteRequest.builder().applyMutation(notifyObjectCompleteRequest)).build()), requestBody);
    }

    default public CompletableFuture<NotifyObjectCompleteResponse> notifyObjectComplete(NotifyObjectCompleteRequest notifyObjectCompleteRequest, Path sourcePath) {
        return this.notifyObjectComplete(notifyObjectCompleteRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<NotifyObjectCompleteResponse> notifyObjectComplete(Consumer<NotifyObjectCompleteRequest.Builder> notifyObjectCompleteRequest, Path sourcePath) {
        return this.notifyObjectComplete((NotifyObjectCompleteRequest)((Object)((NotifyObjectCompleteRequest.Builder)NotifyObjectCompleteRequest.builder().applyMutation(notifyObjectCompleteRequest)).build()), sourcePath);
    }

    default public CompletableFuture<PutChunkResponse> putChunk(PutChunkRequest putChunkRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutChunkResponse> putChunk(Consumer<PutChunkRequest.Builder> putChunkRequest, AsyncRequestBody requestBody) {
        return this.putChunk((PutChunkRequest)((Object)((PutChunkRequest.Builder)PutChunkRequest.builder().applyMutation(putChunkRequest)).build()), requestBody);
    }

    default public CompletableFuture<PutChunkResponse> putChunk(PutChunkRequest putChunkRequest, Path sourcePath) {
        return this.putChunk(putChunkRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<PutChunkResponse> putChunk(Consumer<PutChunkRequest.Builder> putChunkRequest, Path sourcePath) {
        return this.putChunk((PutChunkRequest)((Object)((PutChunkRequest.Builder)PutChunkRequest.builder().applyMutation(putChunkRequest)).build()), sourcePath);
    }

    default public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<PutObjectResponse> putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, AsyncRequestBody requestBody) {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), requestBody);
    }

    default public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, Path sourcePath) {
        return this.putObject(putObjectRequest, AsyncRequestBody.fromFile((Path)sourcePath));
    }

    default public CompletableFuture<PutObjectResponse> putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, Path sourcePath) {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), sourcePath);
    }

    default public CompletableFuture<StartObjectResponse> startObject(StartObjectRequest startObjectRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartObjectResponse> startObject(Consumer<StartObjectRequest.Builder> startObjectRequest) {
        return this.startObject((StartObjectRequest)((Object)((StartObjectRequest.Builder)StartObjectRequest.builder().applyMutation(startObjectRequest)).build()));
    }

    default public BackupStorageServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static BackupStorageAsyncClient create() {
        return (BackupStorageAsyncClient)BackupStorageAsyncClient.builder().build();
    }

    public static BackupStorageAsyncClientBuilder builder() {
        return new DefaultBackupStorageAsyncClientBuilder();
    }
}

