/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EBSResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EBSResultItem> {
    private static final SdkField<String> BACKUP_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupResourceArn").getter(EBSResultItem.getter(EBSResultItem::backupResourceArn)).setter(EBSResultItem.setter(Builder::backupResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArn").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResourceArn").getter(EBSResultItem.getter(EBSResultItem::sourceResourceArn)).setter(EBSResultItem.setter(Builder::sourceResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(EBSResultItem.getter(EBSResultItem::backupVaultName)).setter(EBSResultItem.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemIdentifier").getter(EBSResultItem.getter(EBSResultItem::fileSystemIdentifier)).setter(EBSResultItem.setter(Builder::fileSystemIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemIdentifier").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilePath").getter(EBSResultItem.getter(EBSResultItem::filePath)).setter(EBSResultItem.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()}).build();
    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileSize").getter(EBSResultItem.getter(EBSResultItem::fileSize)).setter(EBSResultItem.setter(Builder::fileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSize").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(EBSResultItem.getter(EBSResultItem::creationTime)).setter(EBSResultItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EBSResultItem.getter(EBSResultItem::lastModifiedTime)).setter(EBSResultItem.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RESOURCE_ARN_FIELD, SOURCE_RESOURCE_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, FILE_SYSTEM_IDENTIFIER_FIELD, FILE_PATH_FIELD, FILE_SIZE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EBSResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backupResourceArn;
    private final String sourceResourceArn;
    private final String backupVaultName;
    private final String fileSystemIdentifier;
    private final String filePath;
    private final Long fileSize;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private EBSResultItem(BuilderImpl builder) {
        this.backupResourceArn = builder.backupResourceArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.backupVaultName = builder.backupVaultName;
        this.fileSystemIdentifier = builder.fileSystemIdentifier;
        this.filePath = builder.filePath;
        this.fileSize = builder.fileSize;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String backupResourceArn() {
        return this.backupResourceArn;
    }

    public final String sourceResourceArn() {
        return this.sourceResourceArn;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String fileSystemIdentifier() {
        return this.fileSystemIdentifier;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final Long fileSize() {
        return this.fileSize;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSResultItem)) {
            return false;
        }
        EBSResultItem other = (EBSResultItem)obj;
        return Objects.equals(this.backupResourceArn(), other.backupResourceArn()) && Objects.equals(this.sourceResourceArn(), other.sourceResourceArn()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.fileSystemIdentifier(), other.fileSystemIdentifier()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.fileSize(), other.fileSize()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"EBSResultItem").add("BackupResourceArn", (Object)this.backupResourceArn()).add("SourceResourceArn", (Object)this.sourceResourceArn()).add("BackupVaultName", (Object)this.backupVaultName()).add("FileSystemIdentifier", (Object)this.fileSystemIdentifier()).add("FilePath", (Object)(this.filePath() == null ? null : "*** Sensitive Data Redacted ***")).add("FileSize", (Object)this.fileSize()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupResourceArn": {
                return Optional.ofNullable(clazz.cast(this.backupResourceArn()));
            }
            case "SourceResourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArn()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "FileSystemIdentifier": {
                return Optional.ofNullable(clazz.cast(this.fileSystemIdentifier()));
            }
            case "FilePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "FileSize": {
                return Optional.ofNullable(clazz.cast(this.fileSize()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupResourceArn", BACKUP_RESOURCE_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("FileSystemIdentifier", FILE_SYSTEM_IDENTIFIER_FIELD);
        map.put("FilePath", FILE_PATH_FIELD);
        map.put("FileSize", FILE_SIZE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EBSResultItem, T> g) {
        return obj -> g.apply((EBSResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupResourceArn;
        private String sourceResourceArn;
        private String backupVaultName;
        private String fileSystemIdentifier;
        private String filePath;
        private Long fileSize;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSResultItem model) {
            this.backupResourceArn(model.backupResourceArn);
            this.sourceResourceArn(model.sourceResourceArn);
            this.backupVaultName(model.backupVaultName);
            this.fileSystemIdentifier(model.fileSystemIdentifier);
            this.filePath(model.filePath);
            this.fileSize(model.fileSize);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getBackupResourceArn() {
            return this.backupResourceArn;
        }

        public final void setBackupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
        }

        @Override
        public final Builder backupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return this.sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getFileSystemIdentifier() {
            return this.fileSystemIdentifier;
        }

        public final void setFileSystemIdentifier(String fileSystemIdentifier) {
            this.fileSystemIdentifier = fileSystemIdentifier;
        }

        @Override
        public final Builder fileSystemIdentifier(String fileSystemIdentifier) {
            this.fileSystemIdentifier = fileSystemIdentifier;
            return this;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Long getFileSize() {
            return this.fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public EBSResultItem build() {
            return new EBSResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EBSResultItem> {
        public Builder backupResourceArn(String var1);

        public Builder sourceResourceArn(String var1);

        public Builder backupVaultName(String var1);

        public Builder fileSystemIdentifier(String var1);

        public Builder filePath(String var1);

        public Builder fileSize(Long var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

