/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupsearch.model.ExportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportJobSummary> {
    private static final SdkField<String> EXPORT_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportJobIdentifier").getter(ExportJobSummary.getter(ExportJobSummary::exportJobIdentifier)).setter(ExportJobSummary.setter(Builder::exportJobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobIdentifier").build()}).build();
    private static final SdkField<String> EXPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportJobArn").getter(ExportJobSummary.getter(ExportJobSummary::exportJobArn)).setter(ExportJobSummary.setter(Builder::exportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ExportJobSummary.getter(ExportJobSummary::statusAsString)).setter(ExportJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ExportJobSummary.getter(ExportJobSummary::creationTime)).setter(ExportJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(ExportJobSummary.getter(ExportJobSummary::completionTime)).setter(ExportJobSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ExportJobSummary.getter(ExportJobSummary::statusMessage)).setter(ExportJobSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobArn").getter(ExportJobSummary.getter(ExportJobSummary::searchJobArn)).setter(ExportJobSummary.setter(Builder::searchJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_IDENTIFIER_FIELD, EXPORT_JOB_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, STATUS_MESSAGE_FIELD, SEARCH_JOB_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String exportJobIdentifier;
    private final String exportJobArn;
    private final String status;
    private final Instant creationTime;
    private final Instant completionTime;
    private final String statusMessage;
    private final String searchJobArn;

    private ExportJobSummary(BuilderImpl builder) {
        this.exportJobIdentifier = builder.exportJobIdentifier;
        this.exportJobArn = builder.exportJobArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.statusMessage = builder.statusMessage;
        this.searchJobArn = builder.searchJobArn;
    }

    public final String exportJobIdentifier() {
        return this.exportJobIdentifier;
    }

    public final String exportJobArn() {
        return this.exportJobArn;
    }

    public final ExportJobStatus status() {
        return ExportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String searchJobArn() {
        return this.searchJobArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobSummary)) {
            return false;
        }
        ExportJobSummary other = (ExportJobSummary)obj;
        return Objects.equals(this.exportJobIdentifier(), other.exportJobIdentifier()) && Objects.equals(this.exportJobArn(), other.exportJobArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.searchJobArn(), other.searchJobArn());
    }

    public final String toString() {
        return ToString.builder((String)"ExportJobSummary").add("ExportJobIdentifier", (Object)this.exportJobIdentifier()).add("ExportJobArn", (Object)this.exportJobArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("StatusMessage", (Object)this.statusMessage()).add("SearchJobArn", (Object)this.searchJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.exportJobIdentifier()));
            }
            case "ExportJobArn": {
                return Optional.ofNullable(clazz.cast(this.exportJobArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "SearchJobArn": {
                return Optional.ofNullable(clazz.cast(this.searchJobArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExportJobIdentifier", EXPORT_JOB_IDENTIFIER_FIELD);
        map.put("ExportJobArn", EXPORT_JOB_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportJobSummary, T> g) {
        return obj -> g.apply((ExportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportJobIdentifier;
        private String exportJobArn;
        private String status;
        private Instant creationTime;
        private Instant completionTime;
        private String statusMessage;
        private String searchJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobSummary model) {
            this.exportJobIdentifier(model.exportJobIdentifier);
            this.exportJobArn(model.exportJobArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.statusMessage(model.statusMessage);
            this.searchJobArn(model.searchJobArn);
        }

        public final String getExportJobIdentifier() {
            return this.exportJobIdentifier;
        }

        public final void setExportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
        }

        @Override
        public final Builder exportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
            return this;
        }

        public final String getExportJobArn() {
            return this.exportJobArn;
        }

        public final void setExportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
        }

        @Override
        public final Builder exportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getSearchJobArn() {
            return this.searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        public ExportJobSummary build() {
            return new ExportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportJobSummary> {
        public Builder exportJobIdentifier(String var1);

        public Builder exportJobArn(String var1);

        public Builder status(String var1);

        public Builder status(ExportJobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder statusMessage(String var1);

        public Builder searchJobArn(String var1);
    }
}

