/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupgateway.BackupGatewayClient;
import software.amazon.awssdk.services.backupgateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupgateway.model.Hypervisor;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse;

public class ListHypervisorsIterable
implements SdkIterable<ListHypervisorsResponse> {
    private final BackupGatewayClient client;
    private final ListHypervisorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHypervisorsIterable(BackupGatewayClient client, ListHypervisorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHypervisorsResponseFetcher();
    }

    public Iterator<ListHypervisorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Hypervisor> hypervisors() {
        Function<ListHypervisorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hypervisors() != null) {
                return response.hypervisors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHypervisorsResponseFetcher
    implements SyncPageFetcher<ListHypervisorsResponse> {
        private ListHypervisorsResponseFetcher() {
        }

        public boolean hasNextPage(ListHypervisorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHypervisorsResponse nextPage(ListHypervisorsResponse previousPage) {
            if (previousPage == null) {
                return ListHypervisorsIterable.this.client.listHypervisors(ListHypervisorsIterable.this.firstRequest);
            }
            return ListHypervisorsIterable.this.client.listHypervisors((ListHypervisorsRequest)((Object)ListHypervisorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

