/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateGatewayToServerRequest
extends BackupGatewayRequest
implements ToCopyableBuilder<Builder, AssociateGatewayToServerRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(AssociateGatewayToServerRequest.getter(AssociateGatewayToServerRequest::gatewayArn)).setter(AssociateGatewayToServerRequest.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()}).build();
    private static final SdkField<String> SERVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerArn").getter(AssociateGatewayToServerRequest.getter(AssociateGatewayToServerRequest::serverArn)).setter(AssociateGatewayToServerRequest.setter(Builder::serverArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, SERVER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GatewayArn", GATEWAY_ARN_FIELD);
            this.put("ServerArn", SERVER_ARN_FIELD);
        }
    });
    private final String gatewayArn;
    private final String serverArn;

    private AssociateGatewayToServerRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayArn = builder.gatewayArn;
        this.serverArn = builder.serverArn;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String serverArn() {
        return this.serverArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateGatewayToServerRequest)) {
            return false;
        }
        AssociateGatewayToServerRequest other = (AssociateGatewayToServerRequest)((Object)obj);
        return Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.serverArn(), other.serverArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateGatewayToServerRequest").add("GatewayArn", (Object)this.gatewayArn()).add("ServerArn", (Object)this.serverArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "ServerArn": {
                return Optional.ofNullable(clazz.cast(this.serverArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateGatewayToServerRequest, T> g) {
        return obj -> g.apply((AssociateGatewayToServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayArn;
        private String serverArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateGatewayToServerRequest model) {
            super(model);
            this.gatewayArn(model.gatewayArn);
            this.serverArn(model.serverArn);
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getServerArn() {
            return this.serverArn;
        }

        public final void setServerArn(String serverArn) {
            this.serverArn = serverArn;
        }

        @Override
        public final Builder serverArn(String serverArn) {
            this.serverArn = serverArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateGatewayToServerRequest build() {
            return new AssociateGatewayToServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateGatewayToServerRequest> {
        public Builder gatewayArn(String var1);

        public Builder serverArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

