/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backupgateway.BackupGatewayClient;
import software.amazon.awssdk.services.backupgateway.BackupGatewayClientBuilder;
import software.amazon.awssdk.services.backupgateway.BackupGatewayServiceClientConfiguration;
import software.amazon.awssdk.services.backupgateway.DefaultBackupGatewayBaseClientBuilder;
import software.amazon.awssdk.services.backupgateway.DefaultBackupGatewayClient;
import software.amazon.awssdk.services.backupgateway.endpoints.BackupGatewayEndpointProvider;

@SdkInternalApi
final class DefaultBackupGatewayClientBuilder
extends DefaultBackupGatewayBaseClientBuilder<BackupGatewayClientBuilder, BackupGatewayClient>
implements BackupGatewayClientBuilder {
    DefaultBackupGatewayClientBuilder() {
    }

    @Override
    public DefaultBackupGatewayClientBuilder endpointProvider(BackupGatewayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BackupGatewayClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBackupGatewayClientBuilder.validateClientOptions(clientConfiguration);
        BackupGatewayServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBackupGatewayClient client = new DefaultBackupGatewayClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BackupGatewayServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BackupGatewayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

