/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest;
import software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse;
import software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerRequest;
import software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse;
import software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsRequest;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsResponse;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest;
import software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse;
import software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest;
import software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse;
import software.amazon.awssdk.services.backupgateway.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse;
import software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsRequest;
import software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsResponse;
import software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest;
import software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse;
import software.amazon.awssdk.services.backupgateway.model.TagResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.TagResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest;
import software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationResponse;
import software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysPublisher;
import software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsPublisher;
import software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesPublisher;

/**
 * Service client for accessing AWS Backup Gateway asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * <fullname>Backup gateway</fullname>
 * <p>
 * Backup gateway connects Backup to your hypervisor, so you can create, store, and restore backups of your virtual
 * machines (VMs) anywhere, whether on-premises or in the VMware Cloud (VMC) on Amazon Web Services.
 * </p>
 * <p>
 * Add on-premises resources by connecting to a hypervisor through a gateway. Backup will automatically discover the
 * resources in your hypervisor.
 * </p>
 * <p>
 * Use Backup to assign virtual or on-premises resources to a backup plan, or run on-demand backups. Once you have
 * backed up your resources, you can view them and restore them like any resource supported by Backup.
 * </p>
 * <p>
 * To download the Amazon Web Services software to get started, navigate to the Backup console, choose <b>Gateways</b>,
 * then choose <b>Create gateway</b>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BackupGatewayAsyncClient extends AwsClient {
    String SERVICE_NAME = "backup-gateway";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "backup-gateway";

    /**
     * <p>
     * Associates a backup gateway with your server. After you complete the association process, you can back up and
     * restore your VMs through the gateway.
     * </p>
     *
     * @param associateGatewayToServerRequest
     * @return A Java Future containing the result of the AssociateGatewayToServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.AssociateGatewayToServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/AssociateGatewayToServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateGatewayToServerResponse> associateGatewayToServer(
            AssociateGatewayToServerRequest associateGatewayToServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a backup gateway with your server. After you complete the association process, you can back up and
     * restore your VMs through the gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateGatewayToServerRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateGatewayToServerRequest#builder()}
     * </p>
     *
     * @param associateGatewayToServerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateGatewayToServerInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateGatewayToServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.AssociateGatewayToServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/AssociateGatewayToServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateGatewayToServerResponse> associateGatewayToServer(
            Consumer<AssociateGatewayToServerRequest.Builder> associateGatewayToServerRequest) {
        return associateGatewayToServer(AssociateGatewayToServerRequest.builder().applyMutation(associateGatewayToServerRequest)
                .build());
    }

    /**
     * <p>
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the
     * <code>AssociateGatewayToServer</code> operation.
     * </p>
     *
     * @param createGatewayRequest
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a backup gateway. After you create a gateway, you can associate it with a server using the
     * <code>AssociateGatewayToServer</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGatewayRequest#builder()}
     * </p>
     *
     * @param createGatewayRequest
     *        A {@link Consumer} that will call methods on {@link CreateGatewayInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.CreateGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/CreateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGatewayResponse> createGateway(Consumer<CreateGatewayRequest.Builder> createGatewayRequest) {
        return createGateway(CreateGatewayRequest.builder().applyMutation(createGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a backup gateway.
     * </p>
     *
     * @param deleteGatewayRequest
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a backup gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGatewayRequest#builder()}
     * </p>
     *
     * @param deleteGatewayRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGatewayInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.DeleteGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayResponse> deleteGateway(Consumer<DeleteGatewayRequest.Builder> deleteGatewayRequest) {
        return deleteGateway(DeleteGatewayRequest.builder().applyMutation(deleteGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes a hypervisor.
     * </p>
     *
     * @param deleteHypervisorRequest
     * @return A Java Future containing the result of the DeleteHypervisor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.DeleteHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHypervisorResponse> deleteHypervisor(DeleteHypervisorRequest deleteHypervisorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a hypervisor.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHypervisorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHypervisorRequest#builder()}
     * </p>
     *
     * @param deleteHypervisorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHypervisorInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteHypervisor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.DeleteHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DeleteHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHypervisorResponse> deleteHypervisor(
            Consumer<DeleteHypervisorRequest.Builder> deleteHypervisorRequest) {
        return deleteHypervisor(DeleteHypervisorRequest.builder().applyMutation(deleteHypervisorRequest).build());
    }

    /**
     * <p>
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway
     * can no longer access the virtual machines on the server.
     * </p>
     *
     * @param disassociateGatewayFromServerRequest
     * @return A Java Future containing the result of the DisassociateGatewayFromServer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.DisassociateGatewayFromServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DisassociateGatewayFromServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateGatewayFromServerResponse> disassociateGatewayFromServer(
            DisassociateGatewayFromServerRequest disassociateGatewayFromServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a backup gateway from the specified server. After the disassociation process finishes, the gateway
     * can no longer access the virtual machines on the server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateGatewayFromServerRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateGatewayFromServerRequest#builder()}
     * </p>
     *
     * @param disassociateGatewayFromServerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateGatewayFromServerInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateGatewayFromServer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.DisassociateGatewayFromServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/DisassociateGatewayFromServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateGatewayFromServerResponse> disassociateGatewayFromServer(
            Consumer<DisassociateGatewayFromServerRequest.Builder> disassociateGatewayFromServerRequest) {
        return disassociateGatewayFromServer(DisassociateGatewayFromServerRequest.builder()
                .applyMutation(disassociateGatewayFromServerRequest).build());
    }

    /**
     * <p>
     * Retrieves the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth
     * rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to get a gateway's bandwidth
     * rate limit schedule.
     * </p>
     *
     * @param getBandwidthRateLimitScheduleRequest
     * @return A Java Future containing the result of the GetBandwidthRateLimitSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetBandwidthRateLimitSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBandwidthRateLimitScheduleResponse> getBandwidthRateLimitSchedule(
            GetBandwidthRateLimitScheduleRequest getBandwidthRateLimitScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth
     * rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to get a gateway's bandwidth
     * rate limit schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBandwidthRateLimitScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link GetBandwidthRateLimitScheduleRequest#builder()}
     * </p>
     *
     * @param getBandwidthRateLimitScheduleRequest
     *        A {@link Consumer} that will call methods on {@link GetBandwidthRateLimitScheduleInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetBandwidthRateLimitSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetBandwidthRateLimitSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBandwidthRateLimitScheduleResponse> getBandwidthRateLimitSchedule(
            Consumer<GetBandwidthRateLimitScheduleRequest.Builder> getBandwidthRateLimitScheduleRequest) {
        return getBandwidthRateLimitSchedule(GetBandwidthRateLimitScheduleRequest.builder()
                .applyMutation(getBandwidthRateLimitScheduleRequest).build());
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGatewayResponse> getGateway(GetGatewayRequest getGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link GetGatewayRequest#builder()}
     * </p>
     *
     * @param getGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGatewayResponse> getGateway(Consumer<GetGatewayRequest.Builder> getGatewayRequest) {
        return getGateway(GetGatewayRequest.builder().applyMutation(getGatewayRequest).build());
    }

    /**
     * <p>
     * This action requests information about the specified hypervisor to which the gateway will connect. A hypervisor
     * is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.
     * </p>
     *
     * @param getHypervisorRequest
     * @return A Java Future containing the result of the GetHypervisor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetHypervisor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHypervisorResponse> getHypervisor(GetHypervisorRequest getHypervisorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action requests information about the specified hypervisor to which the gateway will connect. A hypervisor
     * is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHypervisorRequest.Builder} avoiding the need to
     * create one manually via {@link GetHypervisorRequest#builder()}
     * </p>
     *
     * @param getHypervisorRequest
     *        A {@link Consumer} that will call methods on {@link GetHypervisorInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetHypervisor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetHypervisor" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetHypervisorResponse> getHypervisor(Consumer<GetHypervisorRequest.Builder> getHypervisorRequest) {
        return getHypervisor(GetHypervisorRequest.builder().applyMutation(getHypervisorRequest).build());
    }

    /**
     * <p>
     * This action retrieves the property mappings for the specified hypervisor. A hypervisor property mapping displays
     * the relationship of entity properties available from the on-premises hypervisor to the properties available in
     * Amazon Web Services.
     * </p>
     *
     * @param getHypervisorPropertyMappingsRequest
     * @return A Java Future containing the result of the GetHypervisorPropertyMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetHypervisorPropertyMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetHypervisorPropertyMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHypervisorPropertyMappingsResponse> getHypervisorPropertyMappings(
            GetHypervisorPropertyMappingsRequest getHypervisorPropertyMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action retrieves the property mappings for the specified hypervisor. A hypervisor property mapping displays
     * the relationship of entity properties available from the on-premises hypervisor to the properties available in
     * Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHypervisorPropertyMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetHypervisorPropertyMappingsRequest#builder()}
     * </p>
     *
     * @param getHypervisorPropertyMappingsRequest
     *        A {@link Consumer} that will call methods on {@link GetHypervisorPropertyMappingsInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetHypervisorPropertyMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetHypervisorPropertyMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetHypervisorPropertyMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHypervisorPropertyMappingsResponse> getHypervisorPropertyMappings(
            Consumer<GetHypervisorPropertyMappingsRequest.Builder> getHypervisorPropertyMappingsRequest) {
        return getHypervisorPropertyMappings(GetHypervisorPropertyMappingsRequest.builder()
                .applyMutation(getHypervisorPropertyMappingsRequest).build());
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
     * </p>
     *
     * @param getVirtualMachineRequest
     * @return A Java Future containing the result of the GetVirtualMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetVirtualMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetVirtualMachine"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVirtualMachineResponse> getVirtualMachine(GetVirtualMachineRequest getVirtualMachineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * By providing the ARN (Amazon Resource Name), this API returns the virtual machine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVirtualMachineRequest.Builder} avoiding the need
     * to create one manually via {@link GetVirtualMachineRequest#builder()}
     * </p>
     *
     * @param getVirtualMachineRequest
     *        A {@link Consumer} that will call methods on {@link GetVirtualMachineInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetVirtualMachine operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.GetVirtualMachine
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/GetVirtualMachine"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVirtualMachineResponse> getVirtualMachine(
            Consumer<GetVirtualMachineRequest.Builder> getVirtualMachineRequest) {
        return getVirtualMachine(GetVirtualMachineRequest.builder().applyMutation(getVirtualMachineRequest).build());
    }

    /**
     * <p>
     * Connect to a hypervisor by importing its configuration.
     * </p>
     *
     * @param importHypervisorConfigurationRequest
     * @return A Java Future containing the result of the ImportHypervisorConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ImportHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ImportHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportHypervisorConfigurationResponse> importHypervisorConfiguration(
            ImportHypervisorConfigurationRequest importHypervisorConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Connect to a hypervisor by importing its configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportHypervisorConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ImportHypervisorConfigurationRequest#builder()}
     * </p>
     *
     * @param importHypervisorConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ImportHypervisorConfigurationInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ImportHypervisorConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ImportHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ImportHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportHypervisorConfigurationResponse> importHypervisorConfiguration(
            Consumer<ImportHypervisorConfigurationRequest.Builder> importHypervisorConfigurationRequest) {
        return importHypervisorConfiguration(ImportHypervisorConfigurationRequest.builder()
                .applyMutation(importHypervisorConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) {
        return new ListGatewaysPublisher(this, listGatewaysRequest);
    }

    /**
     * <p>
     * Lists backup gateways owned by an Amazon Web Services account in an Amazon Web Services Region. The returned list
     * is ordered by gateway Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     *
     * @param listHypervisorsRequest
     * @return A Java Future containing the result of the ListHypervisors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHypervisorsResponse> listHypervisors(ListHypervisorsRequest listHypervisorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHypervisorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListHypervisorsRequest#builder()}
     * </p>
     *
     * @param listHypervisorsRequest
     *        A {@link Consumer} that will call methods on {@link ListHypervisorsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListHypervisors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHypervisorsResponse> listHypervisors(
            Consumer<ListHypervisorsRequest.Builder> listHypervisorsRequest) {
        return listHypervisors(ListHypervisorsRequest.builder().applyMutation(listHypervisorsRequest).build());
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsPublisher publisher = client.listHypervisorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsPublisher publisher = client.listHypervisorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHypervisorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHypervisorsPublisher listHypervisorsPaginator(ListHypervisorsRequest listHypervisorsRequest) {
        return new ListHypervisorsPublisher(this, listHypervisorsRequest);
    }

    /**
     * <p>
     * Lists your hypervisors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsPublisher publisher = client.listHypervisorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsPublisher publisher = client.listHypervisorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHypervisors(software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHypervisorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListHypervisorsRequest#builder()}
     * </p>
     *
     * @param listHypervisorsRequest
     *        A {@link Consumer} that will call methods on {@link ListHypervisorsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListHypervisors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListHypervisors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHypervisorsPublisher listHypervisorsPaginator(Consumer<ListHypervisorsRequest.Builder> listHypervisorsRequest) {
        return listHypervisorsPaginator(ListHypervisorsRequest.builder().applyMutation(listHypervisorsRequest).build());
    }

    /**
     * <p>
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags applied to the resource identified by its Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     *
     * @param listVirtualMachinesRequest
     * @return A Java Future containing the result of the ListVirtualMachines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVirtualMachinesResponse> listVirtualMachines(
            ListVirtualMachinesRequest listVirtualMachinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualMachinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on {@link ListVirtualMachinesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListVirtualMachines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVirtualMachinesResponse> listVirtualMachines(
            Consumer<ListVirtualMachinesRequest.Builder> listVirtualMachinesRequest) {
        return listVirtualMachines(ListVirtualMachinesRequest.builder().applyMutation(listVirtualMachinesRequest).build());
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesPublisher publisher = client.listVirtualMachinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesPublisher publisher = client.listVirtualMachinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVirtualMachinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualMachinesPublisher listVirtualMachinesPaginator(ListVirtualMachinesRequest listVirtualMachinesRequest) {
        return new ListVirtualMachinesPublisher(this, listVirtualMachinesRequest);
    }

    /**
     * <p>
     * Lists your virtual machines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesPublisher publisher = client.listVirtualMachinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesPublisher publisher = client.listVirtualMachinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMachines(software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVirtualMachinesRequest.Builder} avoiding the
     * need to create one manually via {@link ListVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on {@link ListVirtualMachinesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.ListVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/ListVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVirtualMachinesPublisher listVirtualMachinesPaginator(
            Consumer<ListVirtualMachinesRequest.Builder> listVirtualMachinesRequest) {
        return listVirtualMachinesPaginator(ListVirtualMachinesRequest.builder().applyMutation(listVirtualMachinesRequest)
                .build());
    }

    /**
     * <p>
     * This action sets the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have a
     * bandwidth rate limit schedule, which means no bandwidth rate limiting is in effect. Use this to initiate a
     * gateway's bandwidth rate limit schedule.
     * </p>
     *
     * @param putBandwidthRateLimitScheduleRequest
     * @return A Java Future containing the result of the PutBandwidthRateLimitSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.PutBandwidthRateLimitSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBandwidthRateLimitScheduleResponse> putBandwidthRateLimitSchedule(
            PutBandwidthRateLimitScheduleRequest putBandwidthRateLimitScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action sets the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have a
     * bandwidth rate limit schedule, which means no bandwidth rate limiting is in effect. Use this to initiate a
     * gateway's bandwidth rate limit schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBandwidthRateLimitScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link PutBandwidthRateLimitScheduleRequest#builder()}
     * </p>
     *
     * @param putBandwidthRateLimitScheduleRequest
     *        A {@link Consumer} that will call methods on {@link PutBandwidthRateLimitScheduleInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutBandwidthRateLimitSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.PutBandwidthRateLimitSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutBandwidthRateLimitSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBandwidthRateLimitScheduleResponse> putBandwidthRateLimitSchedule(
            Consumer<PutBandwidthRateLimitScheduleRequest.Builder> putBandwidthRateLimitScheduleRequest) {
        return putBandwidthRateLimitSchedule(PutBandwidthRateLimitScheduleRequest.builder()
                .applyMutation(putBandwidthRateLimitScheduleRequest).build());
    }

    /**
     * <p>
     * This action sets the property mappings for the specified hypervisor. A hypervisor property mapping displays the
     * relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon
     * Web Services.
     * </p>
     *
     * @param putHypervisorPropertyMappingsRequest
     * @return A Java Future containing the result of the PutHypervisorPropertyMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.PutHypervisorPropertyMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutHypervisorPropertyMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutHypervisorPropertyMappingsResponse> putHypervisorPropertyMappings(
            PutHypervisorPropertyMappingsRequest putHypervisorPropertyMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action sets the property mappings for the specified hypervisor. A hypervisor property mapping displays the
     * relationship of entity properties available from the on-premises hypervisor to the properties available in Amazon
     * Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutHypervisorPropertyMappingsRequest.Builder}
     * avoiding the need to create one manually via {@link PutHypervisorPropertyMappingsRequest#builder()}
     * </p>
     *
     * @param putHypervisorPropertyMappingsRequest
     *        A {@link Consumer} that will call methods on {@link PutHypervisorPropertyMappingsInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutHypervisorPropertyMappings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.PutHypervisorPropertyMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutHypervisorPropertyMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutHypervisorPropertyMappingsResponse> putHypervisorPropertyMappings(
            Consumer<PutHypervisorPropertyMappingsRequest.Builder> putHypervisorPropertyMappingsRequest) {
        return putHypervisorPropertyMappings(PutHypervisorPropertyMappingsRequest.builder()
                .applyMutation(putHypervisorPropertyMappingsRequest).build());
    }

    /**
     * <p>
     * Set the maintenance start time for a gateway.
     * </p>
     *
     * @param putMaintenanceStartTimeRequest
     * @return A Java Future containing the result of the PutMaintenanceStartTime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.PutMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMaintenanceStartTimeResponse> putMaintenanceStartTime(
            PutMaintenanceStartTimeRequest putMaintenanceStartTimeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the maintenance start time for a gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMaintenanceStartTimeRequest.Builder} avoiding
     * the need to create one manually via {@link PutMaintenanceStartTimeRequest#builder()}
     * </p>
     *
     * @param putMaintenanceStartTimeRequest
     *        A {@link Consumer} that will call methods on {@link PutMaintenanceStartTimeInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutMaintenanceStartTime operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.PutMaintenanceStartTime
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/PutMaintenanceStartTime"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutMaintenanceStartTimeResponse> putMaintenanceStartTime(
            Consumer<PutMaintenanceStartTimeRequest.Builder> putMaintenanceStartTimeRequest) {
        return putMaintenanceStartTime(PutMaintenanceStartTimeRequest.builder().applyMutation(putMaintenanceStartTimeRequest)
                .build());
    }

    /**
     * <p>
     * This action sends a request to sync metadata across the specified virtual machines.
     * </p>
     *
     * @param startVirtualMachinesMetadataSyncRequest
     * @return A Java Future containing the result of the StartVirtualMachinesMetadataSync operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.StartVirtualMachinesMetadataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/StartVirtualMachinesMetadataSync"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartVirtualMachinesMetadataSyncResponse> startVirtualMachinesMetadataSync(
            StartVirtualMachinesMetadataSyncRequest startVirtualMachinesMetadataSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action sends a request to sync metadata across the specified virtual machines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartVirtualMachinesMetadataSyncRequest.Builder}
     * avoiding the need to create one manually via {@link StartVirtualMachinesMetadataSyncRequest#builder()}
     * </p>
     *
     * @param startVirtualMachinesMetadataSyncRequest
     *        A {@link Consumer} that will call methods on {@link StartVirtualMachinesMetadataSyncInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartVirtualMachinesMetadataSync operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.StartVirtualMachinesMetadataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/StartVirtualMachinesMetadataSync"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartVirtualMachinesMetadataSyncResponse> startVirtualMachinesMetadataSync(
            Consumer<StartVirtualMachinesMetadataSyncRequest.Builder> startVirtualMachinesMetadataSyncRequest) {
        return startVirtualMachinesMetadataSync(StartVirtualMachinesMetadataSyncRequest.builder()
                .applyMutation(startVirtualMachinesMetadataSyncRequest).build());
    }

    /**
     * <p>
     * Tag the resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tag the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its
     * resources.
     * </p>
     *
     * @param testHypervisorConfigurationRequest
     * @return A Java Future containing the result of the TestHypervisorConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.TestHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TestHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestHypervisorConfigurationResponse> testHypervisorConfiguration(
            TestHypervisorConfigurationRequest testHypervisorConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests your hypervisor configuration to validate that backup gateway can connect with the hypervisor and its
     * resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestHypervisorConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link TestHypervisorConfigurationRequest#builder()}
     * </p>
     *
     * @param testHypervisorConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link TestHypervisorConfigurationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestHypervisorConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.TestHypervisorConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/TestHypervisorConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestHypervisorConfigurationResponse> testHypervisorConfiguration(
            Consumer<TestHypervisorConfigurationRequest.Builder> testHypervisorConfigurationRequest) {
        return testHypervisorConfiguration(TestHypervisorConfigurationRequest.builder()
                .applyMutation(testHypervisorConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes tags from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in
     * your request.
     * </p>
     *
     * @param updateGatewayInformationRequest
     * @return A Java Future containing the result of the UpdateGatewayInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UpdateGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayInformationResponse> updateGatewayInformation(
            UpdateGatewayInformationRequest updateGatewayInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a gateway's name. Specify which gateway to update using the Amazon Resource Name (ARN) of the gateway in
     * your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayInformationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGatewayInformationRequest#builder()}
     * </p>
     *
     * @param updateGatewayInformationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayInformationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGatewayInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UpdateGatewayInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewayInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayInformationResponse> updateGatewayInformation(
            Consumer<UpdateGatewayInformationRequest.Builder> updateGatewayInformationRequest) {
        return updateGatewayInformation(UpdateGatewayInformationRequest.builder().applyMutation(updateGatewayInformationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     * </p>
     * <note>
     * <p>
     * When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take
     * some time for the update to complete.
     * </p>
     * </note>
     *
     * @param updateGatewaySoftwareNowRequest
     * @return A Java Future containing the result of the UpdateGatewaySoftwareNow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UpdateGatewaySoftwareNow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewaySoftwareNow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewaySoftwareNowResponse> updateGatewaySoftwareNow(
            UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
     * </p>
     * <note>
     * <p>
     * When you make this request, you get a <code>200 OK</code> success response immediately. However, it might take
     * some time for the update to complete.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewaySoftwareNowRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGatewaySoftwareNowRequest#builder()}
     * </p>
     *
     * @param updateGatewaySoftwareNowRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewaySoftwareNowInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGatewaySoftwareNow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UpdateGatewaySoftwareNow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateGatewaySoftwareNow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewaySoftwareNowResponse> updateGatewaySoftwareNow(
            Consumer<UpdateGatewaySoftwareNowRequest.Builder> updateGatewaySoftwareNowRequest) {
        return updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest.builder().applyMutation(updateGatewaySoftwareNowRequest)
                .build());
    }

    /**
     * <p>
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update
     * using the Amazon Resource Name (ARN) of the hypervisor in your request.
     * </p>
     *
     * @param updateHypervisorRequest
     * @return A Java Future containing the result of the UpdateHypervisor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UpdateHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHypervisorResponse> updateHypervisor(UpdateHypervisorRequest updateHypervisorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a hypervisor metadata, including its host, username, and password. Specify which hypervisor to update
     * using the Amazon Resource Name (ARN) of the hypervisor in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHypervisorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateHypervisorRequest#builder()}
     * </p>
     *
     * @param updateHypervisorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateHypervisorInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateHypervisor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation did not succeed because a validation error occurred.</li>
     *         <li>ConflictException The operation cannot proceed because it is not supported.</li>
     *         <li>InternalServerException The operation did not succeed because an internal error occurred. Try again
     *         later.</li>
     *         <li>AccessDeniedException The operation cannot proceed because you have insufficient permissions.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action wasn't found.</li>
     *         <li>ThrottlingException TPS has been limited to protect against intentional or unintentional high request
     *         volumes.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupGatewayException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupGatewayAsyncClient.UpdateHypervisor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-gateway-2021-01-01/UpdateHypervisor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHypervisorResponse> updateHypervisor(
            Consumer<UpdateHypervisorRequest.Builder> updateHypervisorRequest) {
        return updateHypervisor(UpdateHypervisorRequest.builder().applyMutation(updateHypervisorRequest).build());
    }

    @Override
    default BackupGatewayServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BackupGatewayAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BackupGatewayAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BackupGatewayAsyncClient}.
     */
    static BackupGatewayAsyncClientBuilder builder() {
        return new DefaultBackupGatewayAsyncClientBuilder();
    }
}
