/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.HypervisorState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Hypervisor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Hypervisor> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(Hypervisor.getter(Hypervisor::host)).setter(Hypervisor.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HypervisorArn").getter(Hypervisor.getter(Hypervisor::hypervisorArn)).setter(Hypervisor.setter(Builder::hypervisorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(Hypervisor.getter(Hypervisor::kmsKeyArn)).setter(Hypervisor.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Hypervisor.getter(Hypervisor::name)).setter(Hypervisor.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Hypervisor.getter(Hypervisor::stateAsString)).setter(Hypervisor.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, HYPERVISOR_ARN_FIELD, KMS_KEY_ARN_FIELD, NAME_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String host;
    private final String hypervisorArn;
    private final String kmsKeyArn;
    private final String name;
    private final String state;

    private Hypervisor(BuilderImpl builder) {
        this.host = builder.host;
        this.hypervisorArn = builder.hypervisorArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.name = builder.name;
        this.state = builder.state;
    }

    public final String host() {
        return this.host;
    }

    public final String hypervisorArn() {
        return this.hypervisorArn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String name() {
        return this.name;
    }

    public final HypervisorState state() {
        return HypervisorState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hypervisor)) {
            return false;
        }
        Hypervisor other = (Hypervisor)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.hypervisorArn(), other.hypervisorArn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Hypervisor").add("Host", (Object)this.host()).add("HypervisorArn", (Object)this.hypervisorArn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "HypervisorArn": {
                return Optional.ofNullable(clazz.cast(this.hypervisorArn()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hypervisor, T> g) {
        return obj -> g.apply((Hypervisor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private String hypervisorArn;
        private String kmsKeyArn;
        private String name;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Hypervisor model) {
            this.host(model.host);
            this.hypervisorArn(model.hypervisorArn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.name(model.name);
            this.state(model.state);
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        @Transient
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getHypervisorArn() {
            return this.hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        @Transient
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(HypervisorState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public Hypervisor build() {
            return new Hypervisor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Hypervisor> {
        public Builder host(String var1);

        public Builder hypervisorArn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(HypervisorState var1);
    }
}

