/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.Lifecycle;
import software.amazon.awssdk.services.backup.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBackupJobRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, StartBackupJobRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBackupJobRequest.getter(StartBackupJobRequest::backupVaultName)).setter(StartBackupJobRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBackupJobRequest.getter(StartBackupJobRequest::resourceArn)).setter(StartBackupJobRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBackupJobRequest.getter(StartBackupJobRequest::iamRoleArn)).setter(StartBackupJobRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartBackupJobRequest.getter(StartBackupJobRequest::idempotencyToken)).setter(StartBackupJobRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<Long> START_WINDOW_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartBackupJobRequest.getter(StartBackupJobRequest::startWindowMinutes)).setter(StartBackupJobRequest.setter(Builder::startWindowMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowMinutes").build()}).build();
    private static final SdkField<Long> COMPLETE_WINDOW_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartBackupJobRequest.getter(StartBackupJobRequest::completeWindowMinutes)).setter(StartBackupJobRequest.setter(Builder::completeWindowMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompleteWindowMinutes").build()}).build();
    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartBackupJobRequest.getter(StartBackupJobRequest::lifecycle)).setter(StartBackupJobRequest.setter(Builder::lifecycle)).constructor(Lifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<Map<String, String>> RECOVERY_POINT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(StartBackupJobRequest.getter(StartBackupJobRequest::recoveryPointTags)).setter(StartBackupJobRequest.setter(Builder::recoveryPointTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, RESOURCE_ARN_FIELD, IAM_ROLE_ARN_FIELD, IDEMPOTENCY_TOKEN_FIELD, START_WINDOW_MINUTES_FIELD, COMPLETE_WINDOW_MINUTES_FIELD, LIFECYCLE_FIELD, RECOVERY_POINT_TAGS_FIELD));
    private final String backupVaultName;
    private final String resourceArn;
    private final String iamRoleArn;
    private final String idempotencyToken;
    private final Long startWindowMinutes;
    private final Long completeWindowMinutes;
    private final Lifecycle lifecycle;
    private final Map<String, String> recoveryPointTags;

    private StartBackupJobRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.resourceArn = builder.resourceArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.startWindowMinutes = builder.startWindowMinutes;
        this.completeWindowMinutes = builder.completeWindowMinutes;
        this.lifecycle = builder.lifecycle;
        this.recoveryPointTags = builder.recoveryPointTags;
    }

    public String backupVaultName() {
        return this.backupVaultName;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Long startWindowMinutes() {
        return this.startWindowMinutes;
    }

    public Long completeWindowMinutes() {
        return this.completeWindowMinutes;
    }

    public Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public Map<String, String> recoveryPointTags() {
        return this.recoveryPointTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.startWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.completeWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointTags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBackupJobRequest)) {
            return false;
        }
        StartBackupJobRequest other = (StartBackupJobRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.startWindowMinutes(), other.startWindowMinutes()) && Objects.equals(this.completeWindowMinutes(), other.completeWindowMinutes()) && Objects.equals(this.lifecycle(), other.lifecycle()) && Objects.equals(this.recoveryPointTags(), other.recoveryPointTags());
    }

    public String toString() {
        return ToString.builder((String)"StartBackupJobRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("ResourceArn", (Object)this.resourceArn()).add("IamRoleArn", (Object)this.iamRoleArn()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("StartWindowMinutes", (Object)this.startWindowMinutes()).add("CompleteWindowMinutes", (Object)this.completeWindowMinutes()).add("Lifecycle", (Object)this.lifecycle()).add("RecoveryPointTags", (Object)(this.recoveryPointTags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "StartWindowMinutes": {
                return Optional.ofNullable(clazz.cast(this.startWindowMinutes()));
            }
            case "CompleteWindowMinutes": {
                return Optional.ofNullable(clazz.cast(this.completeWindowMinutes()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "RecoveryPointTags": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointTags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBackupJobRequest, T> g) {
        return obj -> g.apply((StartBackupJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String resourceArn;
        private String iamRoleArn;
        private String idempotencyToken;
        private Long startWindowMinutes;
        private Long completeWindowMinutes;
        private Lifecycle lifecycle;
        private Map<String, String> recoveryPointTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartBackupJobRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.resourceArn(model.resourceArn);
            this.iamRoleArn(model.iamRoleArn);
            this.idempotencyToken(model.idempotencyToken);
            this.startWindowMinutes(model.startWindowMinutes);
            this.completeWindowMinutes(model.completeWindowMinutes);
            this.lifecycle(model.lifecycle);
            this.recoveryPointTags(model.recoveryPointTags);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Long getStartWindowMinutes() {
            return this.startWindowMinutes;
        }

        @Override
        public final Builder startWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
            return this;
        }

        public final void setStartWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
        }

        public final Long getCompleteWindowMinutes() {
            return this.completeWindowMinutes;
        }

        @Override
        public final Builder completeWindowMinutes(Long completeWindowMinutes) {
            this.completeWindowMinutes = completeWindowMinutes;
            return this;
        }

        public final void setCompleteWindowMinutes(Long completeWindowMinutes) {
            this.completeWindowMinutes = completeWindowMinutes;
        }

        public final Lifecycle.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        public final Map<String, String> getRecoveryPointTags() {
            return this.recoveryPointTags;
        }

        @Override
        public final Builder recoveryPointTags(Map<String, String> recoveryPointTags) {
            this.recoveryPointTags = TagsCopier.copy(recoveryPointTags);
            return this;
        }

        public final void setRecoveryPointTags(Map<String, String> recoveryPointTags) {
            this.recoveryPointTags = TagsCopier.copy(recoveryPointTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBackupJobRequest build() {
            return new StartBackupJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBackupJobRequest> {
        public Builder backupVaultName(String var1);

        public Builder resourceArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder idempotencyToken(String var1);

        public Builder startWindowMinutes(Long var1);

        public Builder completeWindowMinutes(Long var1);

        public Builder lifecycle(Lifecycle var1);

        default public Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return this.lifecycle((Lifecycle)((Lifecycle.Builder)Lifecycle.builder().applyMutation(lifecycle)).build());
        }

        public Builder recoveryPointTags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

