/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BackupVaultEvent {
    BACKUP_JOB_STARTED("BACKUP_JOB_STARTED"),
    BACKUP_JOB_COMPLETED("BACKUP_JOB_COMPLETED"),
    BACKUP_JOB_SUCCESSFUL("BACKUP_JOB_SUCCESSFUL"),
    BACKUP_JOB_FAILED("BACKUP_JOB_FAILED"),
    BACKUP_JOB_EXPIRED("BACKUP_JOB_EXPIRED"),
    RESTORE_JOB_STARTED("RESTORE_JOB_STARTED"),
    RESTORE_JOB_COMPLETED("RESTORE_JOB_COMPLETED"),
    RESTORE_JOB_SUCCESSFUL("RESTORE_JOB_SUCCESSFUL"),
    RESTORE_JOB_FAILED("RESTORE_JOB_FAILED"),
    COPY_JOB_STARTED("COPY_JOB_STARTED"),
    COPY_JOB_SUCCESSFUL("COPY_JOB_SUCCESSFUL"),
    COPY_JOB_FAILED("COPY_JOB_FAILED"),
    RECOVERY_POINT_MODIFIED("RECOVERY_POINT_MODIFIED"),
    BACKUP_PLAN_CREATED("BACKUP_PLAN_CREATED"),
    BACKUP_PLAN_MODIFIED("BACKUP_PLAN_MODIFIED"),
    S3_BACKUP_OBJECT_FAILED("S3_BACKUP_OBJECT_FAILED"),
    S3_RESTORE_OBJECT_FAILED("S3_RESTORE_OBJECT_FAILED"),
    CONTINUOUS_BACKUP_INTERRUPTED("CONTINUOUS_BACKUP_INTERRUPTED"),
    RECOVERY_POINT_INDEX_COMPLETED("RECOVERY_POINT_INDEX_COMPLETED"),
    RECOVERY_POINT_INDEX_DELETED("RECOVERY_POINT_INDEX_DELETED"),
    RECOVERY_POINT_INDEXING_FAILED("RECOVERY_POINT_INDEXING_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BackupVaultEvent> VALUE_MAP;
    private final String value;

    private BackupVaultEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackupVaultEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackupVaultEvent> knownValues() {
        EnumSet<BackupVaultEvent> knownValues = EnumSet.allOf(BackupVaultEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BackupVaultEvent.class, BackupVaultEvent::toString);
    }
}

