/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse;
import software.amazon.awssdk.services.backup.model.RestoreTestingPlanForList;

public class ListRestoreTestingPlansPublisher
implements SdkPublisher<ListRestoreTestingPlansResponse> {
    private final BackupAsyncClient client;
    private final ListRestoreTestingPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRestoreTestingPlansPublisher(BackupAsyncClient client, ListRestoreTestingPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRestoreTestingPlansPublisher(BackupAsyncClient client, ListRestoreTestingPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRestoreTestingPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRestoreTestingPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RestoreTestingPlanForList> restoreTestingPlans() {
        return this.flatMapIterable(response -> response.restoreTestingPlans());
    }

    private class ListRestoreTestingPlansResponseFetcher
    implements AsyncPageFetcher<ListRestoreTestingPlansResponse> {
        private ListRestoreTestingPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreTestingPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRestoreTestingPlansResponse> nextPage(ListRestoreTestingPlansResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreTestingPlansPublisher.this.client.listRestoreTestingPlans(ListRestoreTestingPlansPublisher.this.firstRequest);
            }
            return ListRestoreTestingPlansPublisher.this.client.listRestoreTestingPlans((ListRestoreTestingPlansRequest)((Object)ListRestoreTestingPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

