/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRestoreAccessBackupVaultRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateRestoreAccessBackupVaultRequest> {
    private static final SdkField<String> SOURCE_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBackupVaultArn").getter(CreateRestoreAccessBackupVaultRequest.getter(CreateRestoreAccessBackupVaultRequest::sourceBackupVaultArn)).setter(CreateRestoreAccessBackupVaultRequest.setter(Builder::sourceBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(CreateRestoreAccessBackupVaultRequest.getter(CreateRestoreAccessBackupVaultRequest::backupVaultName)).setter(CreateRestoreAccessBackupVaultRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<Map<String, String>> BACKUP_VAULT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BackupVaultTags").getter(CreateRestoreAccessBackupVaultRequest.getter(CreateRestoreAccessBackupVaultRequest::backupVaultTags)).setter(CreateRestoreAccessBackupVaultRequest.setter(Builder::backupVaultTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateRestoreAccessBackupVaultRequest.getter(CreateRestoreAccessBackupVaultRequest::creatorRequestId)).setter(CreateRestoreAccessBackupVaultRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> REQUESTER_COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequesterComment").getter(CreateRestoreAccessBackupVaultRequest.getter(CreateRestoreAccessBackupVaultRequest::requesterComment)).setter(CreateRestoreAccessBackupVaultRequest.setter(Builder::requesterComment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterComment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_BACKUP_VAULT_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_TAGS_FIELD, CREATOR_REQUEST_ID_FIELD, REQUESTER_COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRestoreAccessBackupVaultRequest.memberNameToFieldInitializer();
    private final String sourceBackupVaultArn;
    private final String backupVaultName;
    private final Map<String, String> backupVaultTags;
    private final String creatorRequestId;
    private final String requesterComment;

    private CreateRestoreAccessBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.sourceBackupVaultArn = builder.sourceBackupVaultArn;
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultTags = builder.backupVaultTags;
        this.creatorRequestId = builder.creatorRequestId;
        this.requesterComment = builder.requesterComment;
    }

    public final String sourceBackupVaultArn() {
        return this.sourceBackupVaultArn;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final boolean hasBackupVaultTags() {
        return this.backupVaultTags != null && !(this.backupVaultTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> backupVaultTags() {
        return this.backupVaultTags;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String requesterComment() {
        return this.requesterComment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupVaultTags() ? this.backupVaultTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterComment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreAccessBackupVaultRequest)) {
            return false;
        }
        CreateRestoreAccessBackupVaultRequest other = (CreateRestoreAccessBackupVaultRequest)((Object)obj);
        return Objects.equals(this.sourceBackupVaultArn(), other.sourceBackupVaultArn()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && this.hasBackupVaultTags() == other.hasBackupVaultTags() && Objects.equals(this.backupVaultTags(), other.backupVaultTags()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.requesterComment(), other.requesterComment());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRestoreAccessBackupVaultRequest").add("SourceBackupVaultArn", (Object)this.sourceBackupVaultArn()).add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultTags", (Object)(this.backupVaultTags() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatorRequestId", (Object)this.creatorRequestId()).add("RequesterComment", (Object)(this.requesterComment() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupVaultArn()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultTags": {
                return Optional.ofNullable(clazz.cast(this.backupVaultTags()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "RequesterComment": {
                return Optional.ofNullable(clazz.cast(this.requesterComment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceBackupVaultArn", SOURCE_BACKUP_VAULT_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("BackupVaultTags", BACKUP_VAULT_TAGS_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("RequesterComment", REQUESTER_COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreAccessBackupVaultRequest, T> g) {
        return obj -> g.apply((CreateRestoreAccessBackupVaultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String sourceBackupVaultArn;
        private String backupVaultName;
        private Map<String, String> backupVaultTags = DefaultSdkAutoConstructMap.getInstance();
        private String creatorRequestId;
        private String requesterComment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreAccessBackupVaultRequest model) {
            super(model);
            this.sourceBackupVaultArn(model.sourceBackupVaultArn);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultTags(model.backupVaultTags);
            this.creatorRequestId(model.creatorRequestId);
            this.requesterComment(model.requesterComment);
        }

        public final String getSourceBackupVaultArn() {
            return this.sourceBackupVaultArn;
        }

        public final void setSourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
        }

        @Override
        public final Builder sourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Map<String, String> getBackupVaultTags() {
            if (this.backupVaultTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.backupVaultTags;
        }

        public final void setBackupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
        }

        @Override
        public final Builder backupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getRequesterComment() {
            return this.requesterComment;
        }

        public final void setRequesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
        }

        @Override
        public final Builder requesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestoreAccessBackupVaultRequest build() {
            return new CreateRestoreAccessBackupVaultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRestoreAccessBackupVaultRequest> {
        public Builder sourceBackupVaultArn(String var1);

        public Builder backupVaultName(String var1);

        public Builder backupVaultTags(Map<String, String> var1);

        public Builder creatorRequestId(String var1);

        public Builder requesterComment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

