/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.ResourceSelection;
import software.amazon.awssdk.services.backup.model.ResourceSelectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TieringConfigurationInputForUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TieringConfigurationInputForUpdate> {
    private static final SdkField<List<ResourceSelection>> RESOURCE_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceSelection").getter(TieringConfigurationInputForUpdate.getter(TieringConfigurationInputForUpdate::resourceSelection)).setter(TieringConfigurationInputForUpdate.setter(Builder::resourceSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSelection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(TieringConfigurationInputForUpdate.getter(TieringConfigurationInputForUpdate::backupVaultName)).setter(TieringConfigurationInputForUpdate.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SELECTION_FIELD, BACKUP_VAULT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TieringConfigurationInputForUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ResourceSelection> resourceSelection;
    private final String backupVaultName;

    private TieringConfigurationInputForUpdate(BuilderImpl builder) {
        this.resourceSelection = builder.resourceSelection;
        this.backupVaultName = builder.backupVaultName;
    }

    public final boolean hasResourceSelection() {
        return this.resourceSelection != null && !(this.resourceSelection instanceof SdkAutoConstructList);
    }

    public final List<ResourceSelection> resourceSelection() {
        return this.resourceSelection;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceSelection() ? this.resourceSelection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TieringConfigurationInputForUpdate)) {
            return false;
        }
        TieringConfigurationInputForUpdate other = (TieringConfigurationInputForUpdate)obj;
        return this.hasResourceSelection() == other.hasResourceSelection() && Objects.equals(this.resourceSelection(), other.resourceSelection()) && Objects.equals(this.backupVaultName(), other.backupVaultName());
    }

    public final String toString() {
        return ToString.builder((String)"TieringConfigurationInputForUpdate").add("ResourceSelection", this.hasResourceSelection() ? this.resourceSelection() : null).add("BackupVaultName", (Object)this.backupVaultName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceSelection": {
                return Optional.ofNullable(clazz.cast(this.resourceSelection()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceSelection", RESOURCE_SELECTION_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TieringConfigurationInputForUpdate, T> g) {
        return obj -> g.apply((TieringConfigurationInputForUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourceSelection> resourceSelection = DefaultSdkAutoConstructList.getInstance();
        private String backupVaultName;

        private BuilderImpl() {
        }

        private BuilderImpl(TieringConfigurationInputForUpdate model) {
            this.resourceSelection(model.resourceSelection);
            this.backupVaultName(model.backupVaultName);
        }

        public final List<ResourceSelection.Builder> getResourceSelection() {
            List<ResourceSelection.Builder> result = ResourceSelectionsCopier.copyToBuilder(this.resourceSelection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSelection(Collection<ResourceSelection.BuilderImpl> resourceSelection) {
            this.resourceSelection = ResourceSelectionsCopier.copyFromBuilder(resourceSelection);
        }

        @Override
        public final Builder resourceSelection(Collection<ResourceSelection> resourceSelection) {
            this.resourceSelection = ResourceSelectionsCopier.copy(resourceSelection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSelection(ResourceSelection ... resourceSelection) {
            this.resourceSelection(Arrays.asList(resourceSelection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSelection(Consumer<ResourceSelection.Builder> ... resourceSelection) {
            this.resourceSelection(Stream.of(resourceSelection).map(c -> (ResourceSelection)((ResourceSelection.Builder)ResourceSelection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public TieringConfigurationInputForUpdate build() {
            return new TieringConfigurationInputForUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TieringConfigurationInputForUpdate> {
        public Builder resourceSelection(Collection<ResourceSelection> var1);

        public Builder resourceSelection(ResourceSelection ... var1);

        public Builder resourceSelection(Consumer<ResourceSelection.Builder> ... var1);

        public Builder backupVaultName(String var1);
    }
}

