/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ScanMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartScanJobRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, StartScanJobRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(StartScanJobRequest.getter(StartScanJobRequest::backupVaultName)).setter(StartScanJobRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(StartScanJobRequest.getter(StartScanJobRequest::iamRoleArn)).setter(StartScanJobRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(StartScanJobRequest.getter(StartScanJobRequest::idempotencyToken)).setter(StartScanJobRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareScanner").getter(StartScanJobRequest.getter(StartScanJobRequest::malwareScannerAsString)).setter(StartScanJobRequest.setter(Builder::malwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(StartScanJobRequest.getter(StartScanJobRequest::recoveryPointArn)).setter(StartScanJobRequest.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> SCAN_BASE_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanBaseRecoveryPointArn").getter(StartScanJobRequest.getter(StartScanJobRequest::scanBaseRecoveryPointArn)).setter(StartScanJobRequest.setter(Builder::scanBaseRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanBaseRecoveryPointArn").build()}).build();
    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanMode").getter(StartScanJobRequest.getter(StartScanJobRequest::scanModeAsString)).setter(StartScanJobRequest.setter(Builder::scanMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanMode").build()}).build();
    private static final SdkField<String> SCANNER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScannerRoleArn").getter(StartScanJobRequest.getter(StartScanJobRequest::scannerRoleArn)).setter(StartScanJobRequest.setter(Builder::scannerRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScannerRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, IAM_ROLE_ARN_FIELD, IDEMPOTENCY_TOKEN_FIELD, MALWARE_SCANNER_FIELD, RECOVERY_POINT_ARN_FIELD, SCAN_BASE_RECOVERY_POINT_ARN_FIELD, SCAN_MODE_FIELD, SCANNER_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartScanJobRequest.memberNameToFieldInitializer();
    private final String backupVaultName;
    private final String iamRoleArn;
    private final String idempotencyToken;
    private final String malwareScanner;
    private final String recoveryPointArn;
    private final String scanBaseRecoveryPointArn;
    private final String scanMode;
    private final String scannerRoleArn;

    private StartScanJobRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.iamRoleArn = builder.iamRoleArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.malwareScanner = builder.malwareScanner;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.scanBaseRecoveryPointArn = builder.scanBaseRecoveryPointArn;
        this.scanMode = builder.scanMode;
        this.scannerRoleArn = builder.scannerRoleArn;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(this.malwareScanner);
    }

    public final String malwareScannerAsString() {
        return this.malwareScanner;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String scanBaseRecoveryPointArn() {
        return this.scanBaseRecoveryPointArn;
    }

    public final ScanMode scanMode() {
        return ScanMode.fromValue(this.scanMode);
    }

    public final String scanModeAsString() {
        return this.scanMode;
    }

    public final String scannerRoleArn() {
        return this.scannerRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanBaseRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scannerRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartScanJobRequest)) {
            return false;
        }
        StartScanJobRequest other = (StartScanJobRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.malwareScannerAsString(), other.malwareScannerAsString()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.scanBaseRecoveryPointArn(), other.scanBaseRecoveryPointArn()) && Objects.equals(this.scanModeAsString(), other.scanModeAsString()) && Objects.equals(this.scannerRoleArn(), other.scannerRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"StartScanJobRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("IamRoleArn", (Object)this.iamRoleArn()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("MalwareScanner", (Object)this.malwareScannerAsString()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("ScanBaseRecoveryPointArn", (Object)this.scanBaseRecoveryPointArn()).add("ScanMode", (Object)this.scanModeAsString()).add("ScannerRoleArn", (Object)this.scannerRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "MalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.malwareScannerAsString()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "ScanBaseRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.scanBaseRecoveryPointArn()));
            }
            case "ScanMode": {
                return Optional.ofNullable(clazz.cast(this.scanModeAsString()));
            }
            case "ScannerRoleArn": {
                return Optional.ofNullable(clazz.cast(this.scannerRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("ScanBaseRecoveryPointArn", SCAN_BASE_RECOVERY_POINT_ARN_FIELD);
        map.put("ScanMode", SCAN_MODE_FIELD);
        map.put("ScannerRoleArn", SCANNER_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartScanJobRequest, T> g) {
        return obj -> g.apply((StartScanJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String iamRoleArn;
        private String idempotencyToken;
        private String malwareScanner;
        private String recoveryPointArn;
        private String scanBaseRecoveryPointArn;
        private String scanMode;
        private String scannerRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartScanJobRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.iamRoleArn(model.iamRoleArn);
            this.idempotencyToken(model.idempotencyToken);
            this.malwareScanner(model.malwareScanner);
            this.recoveryPointArn(model.recoveryPointArn);
            this.scanBaseRecoveryPointArn(model.scanBaseRecoveryPointArn);
            this.scanMode(model.scanMode);
            this.scannerRoleArn(model.scannerRoleArn);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getMalwareScanner() {
            return this.malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getScanBaseRecoveryPointArn() {
            return this.scanBaseRecoveryPointArn;
        }

        public final void setScanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
        }

        @Override
        public final Builder scanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
            return this;
        }

        public final String getScanMode() {
            return this.scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final String getScannerRoleArn() {
            return this.scannerRoleArn;
        }

        public final void setScannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
        }

        @Override
        public final Builder scannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartScanJobRequest build() {
            return new StartScanJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartScanJobRequest> {
        public Builder backupVaultName(String var1);

        public Builder iamRoleArn(String var1);

        public Builder idempotencyToken(String var1);

        public Builder malwareScanner(String var1);

        public Builder malwareScanner(MalwareScanner var1);

        public Builder recoveryPointArn(String var1);

        public Builder scanBaseRecoveryPointArn(String var1);

        public Builder scanMode(String var1);

        public Builder scanMode(ScanMode var1);

        public Builder scannerRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

