/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFrameworkRequest extends BackupRequest implements
        ToCopyableBuilder<UpdateFrameworkRequest.Builder, UpdateFrameworkRequest> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkName").getter(getter(UpdateFrameworkRequest::frameworkName))
            .setter(setter(Builder::frameworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("frameworkName").build()).build();

    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkDescription").getter(getter(UpdateFrameworkRequest::frameworkDescription))
            .setter(setter(Builder::frameworkDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkDescription").build())
            .build();

    private static final SdkField<List<FrameworkControl>> FRAMEWORK_CONTROLS_FIELD = SdkField
            .<List<FrameworkControl>> builder(MarshallingType.LIST)
            .memberName("FrameworkControls")
            .getter(getter(UpdateFrameworkRequest::frameworkControls))
            .setter(setter(Builder::frameworkControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FrameworkControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(FrameworkControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(UpdateFrameworkRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD,
            FRAMEWORK_DESCRIPTION_FIELD, FRAMEWORK_CONTROLS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String frameworkName;

    private final String frameworkDescription;

    private final List<FrameworkControl> frameworkControls;

    private final String idempotencyToken;

    private UpdateFrameworkRequest(BuilderImpl builder) {
        super(builder);
        this.frameworkName = builder.frameworkName;
        this.frameworkDescription = builder.frameworkDescription;
        this.frameworkControls = builder.frameworkControls;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting
     * of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * </p>
     * 
     * @return The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
     *         consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public final String frameworkName() {
        return frameworkName;
    }

    /**
     * <p>
     * An optional description of the framework with a maximum 1,024 characters.
     * </p>
     * 
     * @return An optional description of the framework with a maximum 1,024 characters.
     */
    public final String frameworkDescription() {
        return frameworkDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the FrameworkControls property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFrameworkControls() {
        return frameworkControls != null && !(frameworkControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The controls that make up the framework. Each control in the list has a name, input parameters, and scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrameworkControls} method.
     * </p>
     * 
     * @return The controls that make up the framework. Each control in the list has a name, input parameters, and
     *         scope.
     */
    public final List<FrameworkControl> frameworkControls() {
        return frameworkControls;
    }

    /**
     * <p>
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to
     * <code>UpdateFrameworkInput</code>. Retrying a successful request with the same idempotency token results in a
     * success message with no action taken.
     * </p>
     * 
     * @return A customer-chosen string that you can use to distinguish between otherwise identical calls to
     *         <code>UpdateFrameworkInput</code>. Retrying a successful request with the same idempotency token results
     *         in a success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameworkControls() ? frameworkControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFrameworkRequest)) {
            return false;
        }
        UpdateFrameworkRequest other = (UpdateFrameworkRequest) obj;
        return Objects.equals(frameworkName(), other.frameworkName())
                && Objects.equals(frameworkDescription(), other.frameworkDescription())
                && hasFrameworkControls() == other.hasFrameworkControls()
                && Objects.equals(frameworkControls(), other.frameworkControls())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFrameworkRequest").add("FrameworkName", frameworkName())
                .add("FrameworkDescription", frameworkDescription())
                .add("FrameworkControls", hasFrameworkControls() ? frameworkControls() : null)
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FrameworkName":
            return Optional.ofNullable(clazz.cast(frameworkName()));
        case "FrameworkDescription":
            return Optional.ofNullable(clazz.cast(frameworkDescription()));
        case "FrameworkControls":
            return Optional.ofNullable(clazz.cast(frameworkControls()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("frameworkName", FRAMEWORK_NAME_FIELD);
        map.put("FrameworkDescription", FRAMEWORK_DESCRIPTION_FIELD);
        map.put("FrameworkControls", FRAMEWORK_CONTROLS_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFrameworkRequest, T> g) {
        return obj -> g.apply((UpdateFrameworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFrameworkRequest> {
        /**
         * <p>
         * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
         * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * </p>
         * 
         * @param frameworkName
         *        The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
         *        consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkName(String frameworkName);

        /**
         * <p>
         * An optional description of the framework with a maximum 1,024 characters.
         * </p>
         * 
         * @param frameworkDescription
         *        An optional description of the framework with a maximum 1,024 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkDescription(String frameworkDescription);

        /**
         * <p>
         * The controls that make up the framework. Each control in the list has a name, input parameters, and scope.
         * </p>
         * 
         * @param frameworkControls
         *        The controls that make up the framework. Each control in the list has a name, input parameters, and
         *        scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkControls(Collection<FrameworkControl> frameworkControls);

        /**
         * <p>
         * The controls that make up the framework. Each control in the list has a name, input parameters, and scope.
         * </p>
         * 
         * @param frameworkControls
         *        The controls that make up the framework. Each control in the list has a name, input parameters, and
         *        scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkControls(FrameworkControl... frameworkControls);

        /**
         * <p>
         * The controls that make up the framework. Each control in the list has a name, input parameters, and scope.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.FrameworkControl.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.FrameworkControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.FrameworkControl.Builder#build()} is called immediately
         * and its result is passed to {@link #frameworkControls(List<FrameworkControl>)}.
         * 
         * @param frameworkControls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.FrameworkControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkControls(java.util.Collection<FrameworkControl>)
         */
        Builder frameworkControls(Consumer<FrameworkControl.Builder>... frameworkControls);

        /**
         * <p>
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to
         * <code>UpdateFrameworkInput</code>. Retrying a successful request with the same idempotency token results in a
         * success message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer-chosen string that you can use to distinguish between otherwise identical calls to
         *        <code>UpdateFrameworkInput</code>. Retrying a successful request with the same idempotency token
         *        results in a success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String frameworkName;

        private String frameworkDescription;

        private List<FrameworkControl> frameworkControls = DefaultSdkAutoConstructList.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFrameworkRequest model) {
            super(model);
            frameworkName(model.frameworkName);
            frameworkDescription(model.frameworkDescription);
            frameworkControls(model.frameworkControls);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getFrameworkName() {
            return frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkDescription() {
            return frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final List<FrameworkControl.Builder> getFrameworkControls() {
            List<FrameworkControl.Builder> result = FrameworkControlsCopier.copyToBuilder(this.frameworkControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworkControls(Collection<FrameworkControl.BuilderImpl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copyFromBuilder(frameworkControls);
        }

        @Override
        public final Builder frameworkControls(Collection<FrameworkControl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copy(frameworkControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(FrameworkControl... frameworkControls) {
            frameworkControls(Arrays.asList(frameworkControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(Consumer<FrameworkControl.Builder>... frameworkControls) {
            frameworkControls(Stream.of(frameworkControls).map(c -> FrameworkControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFrameworkRequest build() {
            return new UpdateFrameworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
