/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a scanning action that specifies the malware scanner and scan mode to use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanAction implements SdkPojo, Serializable, ToCopyableBuilder<ScanAction.Builder, ScanAction> {
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MalwareScanner").getter(getter(ScanAction::malwareScannerAsString))
            .setter(setter(Builder::malwareScanner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()).build();

    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanMode").getter(getter(ScanAction::scanModeAsString)).setter(setter(Builder::scanMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MALWARE_SCANNER_FIELD,
            SCAN_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String malwareScanner;

    private final String scanMode;

    private ScanAction(BuilderImpl builder) {
        this.malwareScanner = builder.malwareScanner;
        this.scanMode = builder.scanMode;
    }

    /**
     * <p>
     * The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
     * @see MalwareScanner
     */
    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(malwareScanner);
    }

    /**
     * <p>
     * The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
     * @see MalwareScanner
     */
    public final String malwareScannerAsString() {
        return malwareScanner;
    }

    /**
     * <p>
     * The scanning mode to use for the scan action.
     * </p>
     * <p>
     * Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The scanning mode to use for the scan action.</p>
     *         <p>
     *         Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
     * @see ScanMode
     */
    public final ScanMode scanMode() {
        return ScanMode.fromValue(scanMode);
    }

    /**
     * <p>
     * The scanning mode to use for the scan action.
     * </p>
     * <p>
     * Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return The scanning mode to use for the scan action.</p>
     *         <p>
     *         Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
     * @see ScanMode
     */
    public final String scanModeAsString() {
        return scanMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanAction)) {
            return false;
        }
        ScanAction other = (ScanAction) obj;
        return Objects.equals(malwareScannerAsString(), other.malwareScannerAsString())
                && Objects.equals(scanModeAsString(), other.scanModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanAction").add("MalwareScanner", malwareScannerAsString()).add("ScanMode", scanModeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MalwareScanner":
            return Optional.ofNullable(clazz.cast(malwareScannerAsString()));
        case "ScanMode":
            return Optional.ofNullable(clazz.cast(scanModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ScanMode", SCAN_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanAction, T> g) {
        return obj -> g.apply((ScanAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanAction> {
        /**
         * <p>
         * The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
         * </p>
         * 
         * @param malwareScanner
         *        The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(String malwareScanner);

        /**
         * <p>
         * The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
         * </p>
         * 
         * @param malwareScanner
         *        The malware scanner to use for the scan action. Currently only <code>GUARDDUTY</code> is supported.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(MalwareScanner malwareScanner);

        /**
         * <p>
         * The scanning mode to use for the scan action.
         * </p>
         * <p>
         * Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
         * </p>
         * 
         * @param scanMode
         *        The scanning mode to use for the scan action.</p>
         *        <p>
         *        Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(String scanMode);

        /**
         * <p>
         * The scanning mode to use for the scan action.
         * </p>
         * <p>
         * Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
         * </p>
         * 
         * @param scanMode
         *        The scanning mode to use for the scan action.</p>
         *        <p>
         *        Valid values: <code>FULL_SCAN</code> | <code>INCREMENTAL_SCAN</code>.
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(ScanMode scanMode);
    }

    static final class BuilderImpl implements Builder {
        private String malwareScanner;

        private String scanMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanAction model) {
            malwareScanner(model.malwareScanner);
            scanMode(model.scanMode);
        }

        public final String getMalwareScanner() {
            return malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getScanMode() {
            return scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        @Override
        public ScanAction build() {
            return new ScanAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
